/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp;

import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symbol;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symtab;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Type;
import edu.rice.cs.mint.comp.com.sun.tools.javac.comp.AttrContext;
import edu.rice.cs.mint.comp.com.sun.tools.javac.comp.Env;
import edu.rice.cs.mint.comp.com.sun.tools.javac.comp.Resolve;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.JCTree;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.Pretty;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.TreeInfo;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.TreeMaker;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Convert;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JCDiagnostic;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.List;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Log;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Name;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class MSPTreeCodeSerializer
extends Pretty {
    private Symtab syms;
    private TreeMaker make;
    private Names names;
    private Log log;
    private List<Symbol.VarSymbol> classVarsInScope;
    private final Resolve rs;
    private JCDiagnostic.DiagnosticPosition make_pos;
    Env<AttrContext> attrEnv;
    MSPTreeCodeWriter msp_out;

    public MSPTreeCodeSerializer(Symtab symtab, TreeMaker treeMaker, Names names, Log log, Resolve resolve, JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, List<Symbol.VarSymbol> list) {
        super(null, false);
        this.syms = symtab;
        this.make = treeMaker;
        this.names = names;
        this.log = log;
        this.rs = resolve;
        this.make_pos = diagnosticPosition;
        this.attrEnv = env;
        this.classVarsInScope = list;
    }

    public java.util.List<Elem> serializeExpr(JCTree.JCExpression jCExpression) {
        this.msp_out = new MSPTreeCodeWriter();
        try {
            this.printExpr(jCExpression);
        }
        catch (IOException iOException) {
            throw new Pretty.UncheckedIOException(iOException);
        }
        return this.msp_out.getElems();
    }

    public java.util.List<Elem> serializeStats(List<JCTree.JCStatement> list) {
        this.msp_out = new MSPTreeCodeWriter();
        try {
            this.printStats(list);
        }
        catch (IOException iOException) {
            throw new Pretty.UncheckedIOException(iOException);
        }
        return this.msp_out.getElems();
    }

    @Override
    protected void align() throws IOException {
        for (int i = 0; i < this.lmargin; ++i) {
            this.msp_out.write(" ");
        }
    }

    @Override
    protected void open(int n, int n2) throws IOException {
        if (n2 < n) {
            this.msp_out.write("(");
        }
    }

    @Override
    protected void close(int n, int n2) throws IOException {
        if (n2 < n) {
            this.msp_out.write(")");
        }
    }

    @Override
    public void print(Object object) throws IOException {
        this.msp_out.write(Convert.escapeUnicode(object.toString()));
    }

    @Override
    public void println() throws IOException {
        this.msp_out.write(this.lineSep);
    }

    @Override
    public void visitBracketExpr(JCTree.JCBracketExpr jCBracketExpr) {
        throw new AssertionError((Object)"Unexpected bracket in MSPTreeCodeSerializer");
    }

    @Override
    public void visitBracketStat(JCTree.JCBracketStat jCBracketStat) {
        throw new AssertionError((Object)"Unexpected bracket in MSPTreeCodeSerializer");
    }

    @Override
    public void visitEscapeExpr(JCTree.JCEscapeExpr jCEscapeExpr) {
        this.msp_out.writeEscape(jCEscapeExpr.body);
    }

    @Override
    public void visitEscapeStat(JCTree.JCEscapeStat jCEscapeStat) {
        this.msp_out.writeEscapeStat(jCEscapeStat.body);
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (jCIdent.cspCount > 0) {
            this.msp_out.writeCsp(jCIdent);
        } else if (jCIdent.genVarSym != null) {
            this.msp_out.writeStringExpr(this.makeIdent(jCIdent.genVarSym, this.syms.stringType));
        } else if (jCIdent.sym.type.tag == 14) {
            Symbol.VarSymbol varSymbol = null;
            for (Symbol.VarSymbol object : this.classVarsInScope) {
                if (jCIdent.sym != ((Type)object.type.getTypeArguments().head).tsym) continue;
                varSymbol = object;
                break;
            }
            if (varSymbol == null) {
                this.log.error(jCIdent.pos(), "type.variable.without.class.variable.in.scope.used.in.brackets", jCIdent.sym.toString());
            } else {
                JCTree.JCMethodInvocation jCMethodInvocation = this.makeCall(this.makeIdent(varSymbol, varSymbol.type), this.names.fromString("getName"), List.<JCTree.JCExpression>nil());
                JCTree.JCMethodInvocation jCMethodInvocation2 = this.makeCall(jCMethodInvocation, this.names.fromString("replace"), List.of(this.makeLit(this.syms.charType, 36), this.makeLit(this.syms.charType, 46)));
                this.msp_out.writeStringExpr(jCMethodInvocation2);
            }
        } else {
            super.visitIdent(jCIdent);
        }
    }

    @Override
    public void printVarDefName(JCTree.JCVariableDecl jCVariableDecl) throws IOException {
        if (jCVariableDecl.genVarSym != null) {
            this.msp_out.writeStringExpr(this.makeIdent(jCVariableDecl.genVarSym, this.syms.stringType));
        } else {
            super.printVarDefName(jCVariableDecl);
        }
    }

    private JCTree.JCMethodInvocation makeCall(JCTree.JCExpression jCExpression, Name name, List<JCTree.JCExpression> list) {
        assert (jCExpression.type != null);
        Symbol.MethodSymbol methodSymbol = this.lookupMethod(this.make_pos, name, jCExpression.type, TreeInfo.types(list));
        return this.make.App(this.make.Select(jCExpression, methodSymbol), list);
    }

    private Symbol.MethodSymbol lookupMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Name name, Type type, List<Type> list) {
        return this.rs.resolveInternalMethod(diagnosticPosition, this.attrEnv, type, name, list, null);
    }

    JCTree.JCExpression makeLit(Type type, Object object) {
        return this.make.Literal(type.tag, object).setType(type.constType(object));
    }

    JCTree.JCIdent makeIdent(Symbol symbol, Type type) {
        JCTree.JCIdent jCIdent = this.make.Ident(symbol.name);
        jCIdent.setType(type);
        jCIdent.sym = symbol;
        return jCIdent;
    }

    public static class StringExprElem
    extends Elem {
        public JCTree.JCExpression contents;

        public StringExprElem(JCTree.JCExpression jCExpression) {
            this.contents = jCExpression;
        }
    }

    public static class CspElem
    extends Elem {
        public JCTree.JCIdent contents;

        public CspElem(JCTree.JCIdent jCIdent) {
            this.contents = jCIdent;
        }
    }

    public static class EscapeStatElem
    extends Elem {
        public JCTree.JCExpression contents;

        public EscapeStatElem(JCTree.JCExpression jCExpression) {
            this.contents = jCExpression;
        }
    }

    public static class EscapeElem
    extends Elem {
        public JCTree.JCExpression contents;

        public EscapeElem(JCTree.JCExpression jCExpression) {
            this.contents = jCExpression;
        }
    }

    public static class StringElem
    extends Elem {
        public String contents;

        public StringElem(String string) {
            this.contents = string;
        }
    }

    public static abstract class Elem {
    }

    static class MSPTreeCodeWriter
    extends Writer {
        ArrayList<Elem> elems = new ArrayList();
        StringBuilder currentString = new StringBuilder();

        MSPTreeCodeWriter() {
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            this.currentString.append(cArray, n, n2);
        }

        public void writeEscape(JCTree.JCExpression jCExpression) {
            this.flush();
            this.elems.add(new EscapeElem(jCExpression));
        }

        public void writeEscapeStat(JCTree.JCExpression jCExpression) {
            this.flush();
            this.elems.add(new EscapeStatElem(jCExpression));
        }

        public void writeCsp(JCTree.JCIdent jCIdent) {
            this.flush();
            this.elems.add(new CspElem(jCIdent));
        }

        public void writeStringExpr(JCTree.JCExpression jCExpression) {
            this.flush();
            this.elems.add(new StringExprElem(jCExpression));
        }

        @Override
        public void flush() {
            if (this.currentString.length() > 0) {
                String string = this.currentString.toString();
                this.currentString.setLength(0);
                this.elems.add(new StringElem(string));
            }
        }

        @Override
        public void close() {
            this.flush();
        }

        public java.util.List<Elem> getElems() {
            this.flush();
            return new ArrayList<Elem>(this.elems);
        }
    }
}

