/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.model;

import edu.rice.cs.mint.comp.com.sun.tools.javac.code.BoundKind;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symbol;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symtab;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Type;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Types;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Context;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.ListBuffer;
import edu.rice.cs.mint.comp.javax.lang.model.element.Element;
import edu.rice.cs.mint.comp.javax.lang.model.element.TypeElement;
import edu.rice.cs.mint.comp.javax.lang.model.type.ArrayType;
import edu.rice.cs.mint.comp.javax.lang.model.type.DeclaredType;
import edu.rice.cs.mint.comp.javax.lang.model.type.ExecutableType;
import edu.rice.cs.mint.comp.javax.lang.model.type.NoType;
import edu.rice.cs.mint.comp.javax.lang.model.type.NullType;
import edu.rice.cs.mint.comp.javax.lang.model.type.PrimitiveType;
import edu.rice.cs.mint.comp.javax.lang.model.type.ReferenceType;
import edu.rice.cs.mint.comp.javax.lang.model.type.TypeKind;
import edu.rice.cs.mint.comp.javax.lang.model.type.TypeMirror;
import edu.rice.cs.mint.comp.javax.lang.model.type.WildcardType;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class JavacTypes
implements edu.rice.cs.mint.comp.javax.lang.model.util.Types {
    private Symtab syms;
    private Types types;
    private static final Context.Key<JavacTypes> KEY = new Context.Key();
    private static final Set<TypeKind> EXEC_OR_PKG = EnumSet.of(TypeKind.EXECUTABLE, TypeKind.PACKAGE);

    public static JavacTypes instance(Context context) {
        JavacTypes javacTypes = context.get(KEY);
        if (javacTypes == null) {
            javacTypes = new JavacTypes(context);
            context.put(KEY, javacTypes);
        }
        return javacTypes;
    }

    public JavacTypes(Context context) {
        this.setContext(context);
    }

    public void setContext(Context context) {
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
    }

    @Override
    public Element asElement(TypeMirror typeMirror) {
        Type type = JavacTypes.cast(Type.class, typeMirror);
        if (type.tag != 10 && type.tag != 14) {
            return null;
        }
        return type.asElement();
    }

    @Override
    public boolean isSameType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        return this.types.isSameType((Type)typeMirror, (Type)typeMirror2);
    }

    @Override
    public boolean isSubtype(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        this.validateTypeNotIn(typeMirror2, EXEC_OR_PKG);
        return this.types.isSubtype((Type)typeMirror, (Type)typeMirror2);
    }

    @Override
    public boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        this.validateTypeNotIn(typeMirror2, EXEC_OR_PKG);
        return this.types.isAssignable((Type)typeMirror, (Type)typeMirror2);
    }

    @Override
    public boolean contains(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        this.validateTypeNotIn(typeMirror2, EXEC_OR_PKG);
        return ((Type)typeMirror).contains((Type)typeMirror2);
    }

    @Override
    public boolean isSubsignature(ExecutableType executableType, ExecutableType executableType2) {
        return this.types.isSubSignature((Type)((Object)executableType), (Type)((Object)executableType2));
    }

    public List<Type> directSupertypes(TypeMirror typeMirror) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        Type type = (Type)typeMirror;
        Type type2 = this.types.supertype(type);
        return type2 == Type.noType || type2 == type || type2 == null ? this.types.interfaces(type) : this.types.interfaces(type).prepend(type2);
    }

    @Override
    public TypeMirror erasure(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.PACKAGE) {
            throw new IllegalArgumentException(((Object)typeMirror).toString());
        }
        return this.types.erasure((Type)typeMirror);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType primitiveType) {
        return this.types.boxedClass((Type)primitiveType);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror typeMirror) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            throw new IllegalArgumentException(((Object)typeMirror).toString());
        }
        Type type = this.types.unboxedType((Type)typeMirror);
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException(((Object)typeMirror).toString());
        }
        return type;
    }

    @Override
    public TypeMirror capture(TypeMirror typeMirror) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        return this.types.capture((Type)typeMirror);
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return this.syms.booleanType;
            }
            case BYTE: {
                return this.syms.byteType;
            }
            case SHORT: {
                return this.syms.shortType;
            }
            case INT: {
                return this.syms.intType;
            }
            case LONG: {
                return this.syms.longType;
            }
            case CHAR: {
                return this.syms.charType;
            }
            case FLOAT: {
                return this.syms.floatType;
            }
            case DOUBLE: {
                return this.syms.doubleType;
            }
        }
        throw new IllegalArgumentException("Not a primitive type: " + (Object)((Object)typeKind));
    }

    @Override
    public NullType getNullType() {
        return (NullType)((Object)this.syms.botType);
    }

    @Override
    public NoType getNoType(TypeKind typeKind) {
        switch (typeKind) {
            case VOID: {
                return this.syms.voidType;
            }
            case NONE: {
                return Type.noType;
            }
        }
        throw new IllegalArgumentException(typeKind.toString());
    }

    @Override
    public ArrayType getArrayType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case VOID: 
            case EXECUTABLE: 
            case WILDCARD: 
            case PACKAGE: {
                throw new IllegalArgumentException(((Object)typeMirror).toString());
            }
        }
        return new Type.ArrayType((Type)typeMirror, (Symbol.TypeSymbol)this.syms.arrayClass);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        Type type;
        BoundKind boundKind;
        if (typeMirror == null && typeMirror2 == null) {
            boundKind = BoundKind.UNBOUND;
            type = this.syms.objectType;
        } else if (typeMirror2 == null) {
            boundKind = BoundKind.EXTENDS;
            type = (Type)typeMirror;
        } else if (typeMirror == null) {
            boundKind = BoundKind.SUPER;
            type = (Type)typeMirror2;
        } else {
            throw new IllegalArgumentException("Extends and super bounds cannot both be provided");
        }
        switch (type.getKind()) {
            case ARRAY: 
            case DECLARED: 
            case ERROR: 
            case TYPEVAR: {
                return new Type.WildcardType(type, boundKind, this.syms.boundClass);
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeElement;
        if (typeMirrorArray.length == 0) {
            return (DeclaredType)((Object)classSymbol.erasure(this.types));
        }
        if (classSymbol.type.getEnclosingType().isParameterized()) {
            throw new IllegalArgumentException(classSymbol.toString());
        }
        return this.getDeclaredType0(classSymbol.type.getEnclosingType(), classSymbol, typeMirrorArray);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType declaredType, TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        if (declaredType == null) {
            return this.getDeclaredType(typeElement, typeMirrorArray);
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeElement;
        Type type = (Type)((Object)declaredType);
        if (type.tsym != classSymbol.owner.enclClass()) {
            throw new IllegalArgumentException(declaredType.toString());
        }
        if (!type.isParameterized()) {
            return this.getDeclaredType(typeElement, typeMirrorArray);
        }
        return this.getDeclaredType0(type, classSymbol, typeMirrorArray);
    }

    private DeclaredType getDeclaredType0(Type type, Symbol.ClassSymbol classSymbol, TypeMirror ... typeMirrorArray) {
        if (typeMirrorArray.length != classSymbol.type.getTypeArguments().length()) {
            throw new IllegalArgumentException("Incorrect number of type arguments");
        }
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (TypeMirror typeMirror : typeMirrorArray) {
            if (!(typeMirror instanceof ReferenceType) && !(typeMirror instanceof WildcardType)) {
                throw new IllegalArgumentException(((Object)typeMirror).toString());
            }
            listBuffer.append((Type)typeMirror);
        }
        return new Type.ClassType(type, listBuffer.toList(), classSymbol);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        Type type = (Type)((Object)declaredType);
        Symbol symbol = (Symbol)element;
        if (this.types.asSuper(type, symbol.getEnclosingElement()) == null) {
            throw new IllegalArgumentException(symbol + "@" + type);
        }
        return this.types.memberType(type, symbol);
    }

    private void validateTypeNotIn(TypeMirror typeMirror, Set<TypeKind> set) {
        if (set.contains((Object)typeMirror.getKind())) {
            throw new IllegalArgumentException(((Object)typeMirror).toString());
        }
    }

    private static <T> T cast(Class<T> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(object.toString());
        }
        return clazz.cast(object);
    }
}

