/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.util;

import edu.rice.cs.mint.runtime.Code;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Benchmark {
    public static float TARGET_SECONDS = 1.0f;

    public static Task[] stagingTasks(Task task, Thunk<Code<? extends Task>> thunk) {
        Task[] taskArray = new Task[4];
        task.setName("unstaged");
        taskArray[0] = task;
        thunk.setName("gencode");
        taskArray[1] = thunk;
        final Code<? extends Task> code = thunk.value();
        taskArray[2] = new Task("compile"){

            @Override
            public void run() {
                code.run();
            }
        };
        Task task2 = code.run();
        task2.setName("staged");
        taskArray[3] = task2;
        return taskArray;
    }

    public static TimedTask[] benchmark(Task ... taskArray) {
        return Benchmark.benchmark(0, taskArray);
    }

    public static TimedTask[] benchmark(int n, Task ... taskArray) {
        long l;
        long l2;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        for (Task task : taskArray) {
            task.setNormalIndex(n);
            long l3 = 0L;
            long l4 = 0L;
            long l5 = task.reps();
            do {
                l = System.nanoTime();
                int n2 = 0;
                while ((long)n2 < l5 - l4) {
                    task.run();
                    ++n2;
                }
                l2 = System.nanoTime();
                l4 = l5;
                l5 *= 2L;
            } while ((float)(l3 += l2 - l) < 1.0E9f * TARGET_SECONDS);
            task.setReps(l5);
        }
        for (Task task : taskArray) {
            l = System.nanoTime();
            int n3 = 0;
            while ((long)n3 < task.reps()) {
                task.run();
                ++n3;
            }
            l2 = System.nanoTime();
            task.setTime(l2 - l);
        }
        Task[] taskArray2 = new TimedTask[taskArray.length];
        for (int i = 0; i < taskArray.length; ++i) {
            if (taskArray[i].normalIndex() == i) {
                taskArray[i].setPercent(100.0);
            } else {
                double d = taskArray[taskArray[i].normalIndex()].time();
                double d2 = taskArray[taskArray[i].normalIndex()].reps();
                double d3 = d / d2;
                double d4 = taskArray[i].time();
                double d5 = taskArray[i].reps();
                double d6 = d4 / d5;
                taskArray[i].setPercent(100.0 / d3 * d6);
            }
            taskArray2[i] = new TimedTask(taskArray[i]);
        }
        return taskArray2;
    }

    public static void print(TimedTask ... timedTaskArray) {
        Benchmark.print(0, timedTaskArray);
    }

    public static void print(int n, TimedTask ... timedTaskArray) {
        for (int i = 0; i < timedTaskArray.length; ++i) {
            timedTaskArray[i].setNormalIndex(n);
            if (n == i) {
                timedTaskArray[i].setPercent(100.0);
                continue;
            }
            double d = timedTaskArray[n].time();
            double d2 = timedTaskArray[n].reps();
            double d3 = d / d2;
            double d4 = timedTaskArray[i].time();
            double d5 = timedTaskArray[i].reps();
            double d6 = d4 / d5;
            timedTaskArray[i].setPercent(100.0 / d3 * d6);
        }
        System.out.println("Relative to " + timedTaskArray[n].name());
        for (TimedTask timedTask : timedTaskArray) {
            System.out.println(timedTask);
        }
    }

    public static TimedTask[] benchmarkAndPrint(Task ... taskArray) {
        return Benchmark.benchmarkAndPrint(0, taskArray);
    }

    public static TimedTask[] benchmarkAndPrint(int n, Task ... taskArray) {
        TimedTask[] timedTaskArray = Benchmark.benchmark(n, taskArray);
        Benchmark.print(n, timedTaskArray);
        return timedTaskArray;
    }

    static {
        try {
            String string = System.getProperty("edu.rice.cs.mint.util.benchmark.target.seconds");
            if (string != null) {
                float f;
                TARGET_SECONDS = f = new Float(string).floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static abstract class Thunk<T>
    extends Task {
        @Override
        public void run() {
            this.value();
        }

        public abstract T value();
    }

    public static class TimedTask
    extends Task {
        protected Task _task;

        public TimedTask(Task task) {
            this._task = task;
            this._name = task.name();
            this._reps = task.reps();
            this._normalIndex = task.normalIndex();
            this._t = task.time();
            this._percent = task.percent();
        }

        @Override
        public void run() {
            this._task.run();
        }
    }

    public static abstract class Task
    implements Runnable {
        protected String _name;
        protected long _reps = 1L;
        protected int _normalIndex = 0;
        protected long _t;
        protected double _percent;

        public Task() {
        }

        public Task(String string) {
            this();
            this._name = string;
        }

        @Override
        public abstract void run();

        public String name() {
            return this._name;
        }

        public void setName(String string) {
            this._name = string;
        }

        public long reps() {
            return this._reps;
        }

        public void setReps(long l) {
            this._reps = l;
        }

        public long time() {
            return this._t;
        }

        public void setTime(long l) {
            this._t = l;
        }

        public int normalIndex() {
            return this._normalIndex;
        }

        public void setNormalIndex(int n) {
            this._normalIndex = n;
        }

        public double percent() {
            return this._percent;
        }

        public void setPercent(double d) {
            this._percent = d;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%-8s x %,12d reps: ~%7.3f s @ %16.9f mics/rep := %,13.3fx", this.name(), this._reps, (double)this._t / 1.0E9, (double)this._t / 1000.0 / (double)this._reps, this._percent / 100.0);
            return stringWriter.toString();
        }
    }
}

