import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.util.Benchmark;

public class LintFact {
    public static Benchmark.Task[]
        lintTasks(final UnstagedLint.Program unstaged, final StagedLint.Program staged) {
        return Benchmark.stagingTasks(new Benchmark.Task() {
            public void run() {
                int i = unstaged.peval(UnstagedLint.env0, UnstagedLint.fenv0);
            }
        }, new Benchmark.Thunk<Code<? extends Benchmark.Task>>() {
            public Code<? extends Benchmark.Task> value() {
                return <| new Benchmark.Task() {
                    public void run() {
                        int i = `(staged.peval(StagedLint.env0, StagedLint.fenv0));
                    }
                } |>;
            }
        });
    }
    
    public static void main(String[] args) {
        System.out.println("fact(10)");
        Benchmark.TimedTask[] results =
            Benchmark.benchmark(lintTasks(UnstagedLint.termFact, StagedLint.termFact));
        
//        Benchmark.print(0, results); // relative to unstaged
//        System.out.println();
        Benchmark.print(results.length-1, results); // relative to staged
    }
}
