//this is a version of Power.java that has been modified to be used with Timing.java in order to perform timings

import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.SafeCode;

public class Power3 extends YilongTiming {
    
    static Test<Integer> a = new Test<Integer>() {
        public Integer run_unstaged() {
            return power(2, 17);
        }
        
        public Code<? extends TestFun<Integer>> gen_code() {
            return <| new TestFun<Integer>() {
                public Integer run_staged() {
                    return `(spower(<| 2 |>, 17));
                }
            } |>;
        }
    };
    
    public static void main(String[] args){
        //These two lines are to test for bugs
        Code<? extends TestFun<Integer>> b = a.gen_code();
        TestFun<Integer> c = b.run();
        System.out.println(c.run_staged());
        int[] counts = {100000, 100000, 1000, 100000};
        print_timings(a, counts);
    }
    
    public static int power(int x, int n){
        if (n == 1)
            return x;
        else
            return x * power(x, n-1);
    }
    
    public static separable SafeCode<Integer> spower(SafeCode<Integer> x, int n){
        if (n == 1)
            return x;
        else
            return <| `x * `(spower(x, n-1)) |>;
    }
}

