import edu.rice.cs.mint.runtime.Code;

public class YilongTiming{
    
    public interface Test<T> {
        T run_unstaged (); /* run the unstaged test */
        Code<? extends TestFun<T>> gen_code (); /* generate code for the staged test */
    }
    
    public interface TestFun<T> {
        T run_staged (); /* run a staged test */
    }
    
    
    
    public static <T> void print_timings (Test<T> test, int [] counts){
        
        long start = System.nanoTime();
        for(int i = 0; i < counts[0]; i++)
            test.run_unstaged();
        long time = System.nanoTime() - start;
        System.out.println("test.run_unstaged() --> " + (time / counts[0]));
        
        start = System.nanoTime();
        for(int i = 0; i < counts[1]; i++)
            test.gen_code();
        time = System.nanoTime() - start;
        System.out.println("test.gen_code()     --> " + (time / counts[1]));
        
        Code<? extends TestFun<T>> x = test.gen_code();
        start = System.nanoTime();
        for(int i = 0; i < counts[2]; i++)
            x.run();
        time = System.nanoTime() - start;
        System.out.println("x.run()             --> " + (time / counts[2]));
        
        TestFun<T> y = x.run();
        start = System.nanoTime();
        for(int i = 0; i < counts[3]; i++)
            y.run_staged();
        time = System.nanoTime() - start;
        System.out.println("y.run_staged()      --> " + (time / counts[3]));
    }
}
