package hj.array.view;

import hj.array.RegionRectangular;
import hj.lang.ArrayView;

public final class IntArrayView extends ArrayView {

	public final int [] baseArray;

	
	public IntArrayView(int [] baseArray, int offset, RegionRectangular r) {
		super(offset, r);
		this.baseArray = baseArray;
	}


	public final int get(final int i) {
		return baseArray[offset + this.region.ordinal(i)];
	}


	public final int get(final int i, final int j) {
		return baseArray[offset + this.region.ordinal(i,j)];
	}


	public final int get(final int i, final int j, final int k) {
		return baseArray[offset + this.region.ordinal(i,j,k)];
	}

	public final int get(final int i, final int j, final int k, final int l) {
		return baseArray[offset + this.region.ordinal(i,j,k,l)];
	}

	public final int get(final int i, final int j, final int k, final int l, final int m) {
		return baseArray[offset + this.region.ordinal(i,j,k,l,m)];
	}	

	public final void set(int r, final int i) {
		baseArray[offset + this.region.ordinal(i)] = r;
	}


	public final void set(int r, final int i, final int j) {
		baseArray[offset + this.region.ordinal(i,j)] = r;
	}


	public final void set(int r, final int i, final int j, final int k) {
		baseArray[offset + this.region.ordinal(i,j,k)] = r;
	}

	public final void set(int r, final int i, final int j, final int k, final int l) {
		baseArray[offset + this.region.ordinal(i,j,k,l)] = r;
	}

	public final void set(int r, final int i, final int j, final int k, final int l, final int m) {
		baseArray[offset + this.region.ordinal(i,j,k,l,m)] = r;
	}

}
