package mintTestUtil;

public class MatrixMarket {
    public static double[][] load(java.io.File f) {
        double[][] matrix = null;
        try {
            java.io.BufferedReader br = new java.io.BufferedReader(new java.io.FileReader(f));
            String line;
            boolean symmetric = false;
            boolean pattern = false;
            // read header
            while((line=br.readLine())!=null) {
                line = line.trim();
                if (line.startsWith("%%")) {
                    if (!line.contains("matrix")) throw new RuntimeException("Invalid matrix market format: 'matrix' missing");
                    if (!line.contains("coordinate")) throw new RuntimeException("Invalid matrix market format: 'coordinate' missing");
                    if (!line.contains("general") &&
                        !line.contains("symmetric")) throw new RuntimeException("Invalid matrix market format: 'general' or 'symmetric' missing");
                    symmetric = line.contains("symmetric");
                    if (!line.contains("real") &&
                        !line.contains("integer") &&
                        !line.contains("pattern")) throw new RuntimeException("Invalid matrix market format: 'real', 'integer' or 'pattern' missing");
                    pattern = line.contains("pattern");
                    break;
                }
            }
            int rows = 0;
            int cols = 0;
            int entries = 0;
            // read dimension
            while((line=br.readLine())!=null) {
                line = line.trim();
                if (line.startsWith("%")) continue;
                line = line.replaceAll("\\s+"," "); // condense spaces
                String[] arr = line.split(" "); // split at spaces
                if (arr.length!=3) throw new RuntimeException("Invalid matrix market format: 3 numbers per line expected, was: "+line);
                rows = new Integer(arr[0]);
                cols = new Integer(arr[1]);
                entries = new Integer(arr[2]);
                break;
            }
            System.out.println("Rows: "+rows+", Cols: "+cols+", Entries: "+entries);
            matrix = new double[rows][cols];
            // read dimension
            while((line=br.readLine())!=null) {
                line = line.trim();
                if (line.startsWith("%")) continue;
                line = line.replaceAll("\\s+"," "); // condense spaces
                String[] arr = line.split(" "); // split at spaces
                if (pattern) {
                    if (arr.length!=2) throw new RuntimeException("Invalid matrix market format: 2 numbers per line expected, was: "+line);
                    int y = new Integer(arr[0]);
                    int x = new Integer(arr[1]);
                    double z = 1;
                    matrix[y-1][x-1] = z;
                    if (symmetric) {
                        matrix[x-1][y-1] = z;
                    }
                }
                else {
                    if (arr.length!=3) throw new RuntimeException("Invalid matrix market format: 3 numbers per line expected, was: "+line);
                    int y = new Integer(arr[0]);
                    int x = new Integer(arr[1]);
                    double z = new Double(arr[2]);
                    matrix[y-1][x-1] = z;
                    if (symmetric) {
                        matrix[x-1][y-1] = z;
                    }
                }
            }
            br.close();
        }
        catch(Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
        return matrix;
    }
}
