/* an implementation of ClassCode<T> */

package edu.rice.cs.mint.runtime;

import edu.rice.cs.mint.runtime.mspTree.*;
import java.lang.reflect.*;

public final class ClassCode<T> {
    private Class<T> clazz;
    public ClassCode(Class<T> clazz) {
        this.clazz = clazz;
    }
    public Code<T> cast(Code<?> o) {
        return new MSPTreeCode<T>(MSPTreeCode.escape(o), /*mspTree*/
                                  clazz.getName(), /*retTypeName*/
                                  false /*isStat*/);
    }
    public Class<T> getCodeClass() { return clazz; } 
    public <R> FieldCode<T,R> getField(String name) throws NoSuchFieldException {
        return new FieldCode<T,R>(clazz.getField(name));
    }
    @SuppressWarnings({"unchecked","rawtypes"})
    public FieldCode<T,?>[] getFields() {
        Field[] fs = clazz.getFields();
        FieldCode<T,?>[] fcs = (FieldCode<T,?>[])new FieldCode[fs.length];
        for(int i=0; i<fs.length; ++i) {
            fcs[i] = (FieldCode<T,?>)new FieldCode(fs[i]);
        }
        return fcs;
    }
}
