package edu.rice.cs.mint.runtime;

import java.util.HashMap;
import java.util.LinkedList;
import java.io.File;
import java.lang.reflect.*;

public class Mint {
    public static void main(String[] args) {
        execute("edu.rice.cs.drjava.interactions.class.path", args);
    }
    public static void execute(String classPathPropertyName, String... args) {
        if (args.length==0) {
            System.out.println(Mint.class.getName()+" - Mint program launcher");
            System.out.println("Syntax: java "+Mint.class.getName()+" <class> [arguments]");
            System.exit(1);
        }
        final String mainClassName = args[0];
        try {
            HashMapClassLoader classLoader = null;
            if (classPathPropertyName!=null) {
                classLoader = HashMapClassLoader.instance(classPathPropertyName);
            }
            else {
                classLoader = HashMapClassLoader.instance();
            }
            Class<?> cls = classLoader.loadClass(mainClassName);
            
            String[] mainArgs = new String[args.length-1];
            for(int i=1; i<args.length; ++i) { mainArgs[i-1] = args[i]; }
            Class<?>[] paramTypes = {mainArgs.getClass()};
            
            Method main = cls.getMethod("main", paramTypes);
            main.invoke(null, new Object[] {mainArgs});
        }
        catch(ClassNotFoundException e) { handleReflectionException(e, mainClassName); }
        catch(NoSuchMethodException e) { handleReflectionException(e, mainClassName); }
        catch(IllegalAccessException e) { handleReflectionException(e, mainClassName); }
        catch(InvocationTargetException e) { handleReflectionException(e, mainClassName); }
        catch(LinkageError e) { handleReflectionException(e, mainClassName); }
        catch(Throwable t) { t.printStackTrace(System.err); }
    }
    public static void handleReflectionException(Throwable e, String mainClassName) {
        System.err.print("Exception in thread \""+Thread.currentThread().getName()+"\" ");
        if (e.getCause()!=null) {
            StackTraceElement[] stes = e.getCause().getStackTrace();
            // find out where the mainClassName occurs the first time from the bottom
            int end = stes.length-1;
            while(end>0) {
                if (stes[end].getClassName().equals(mainClassName)) {
                    break;
                }
                --end;
            }
            // print out everything including the first occurrence of mainClassName
            // do not print out Mint launcher and reflection stuff
            StackTraceElement[] stesNew = new StackTraceElement[end+1];
            System.arraycopy(stes, 0, stesNew, 0, end+1);
            e.getCause().setStackTrace(stesNew);
            e.getCause().printStackTrace(System.err);
        }
        else {
            e.printStackTrace(System.err);
        }
    }
}
