/* a virtual file whose contents are given as a string */

package edu.rice.cs.mint.runtime;

import java.net.URI;
import java.net.URISyntaxException;

public class StringJavaFileObject extends edu.rice.cs.mint.comp.javax.tools.SimpleJavaFileObject {
    protected String contents;

    public static URI makeURI (String filename) {
        URI retval = null;
        try {
            retval = new URI ("stringfile:/" + filename + ".java");
        } catch (URISyntaxException e) {
            System.err.println ("Internal error in StringJavaFileObject");
            e.printStackTrace (System.err);
            System.exit (1);
        }
        return retval;
    }

    public StringJavaFileObject (String filename, String contents) {
        super (makeURI (filename), Kind.SOURCE);
        this.contents = contents;
//        System.out.println ("filename = " + filename);
    }

    public String getCharContent (boolean ignoreEncodingErrors) {
        return contents;
    }

    public boolean isNameCompatible (String simpleName, Kind kind) {
//        System.out.println ("compare " + getName() + " to : " + simpleName);
        return super.isNameCompatible (simpleName, kind);
    }
    
    @Override
    public String toString() {
        return getName();
    }

}
