/*
 * @test
 *
 * @summary Verify that we cannot assign to a local variable outside the escape
 *
 * @author mgricken
 *
 * @compile/fail/ref=Example3_2_1.out -XDrawDiagnostics Example3_2_1.java
 */

import edu.rice.cs.mint.runtime.*;

public class Example3_2_1 {
    public static int foo() { return 0; }
    public static separable void bar() {
	int x = 0;
	x = 123;
    }
    public static void main(String[] args) {
	Code<Integer> x = <| 0 |>;
	<| {
	    Integer y = foo();
	    // error: x defined outside escape
	    Integer z = `(x = <| y |>);
	    // okay: x2 defined inside escape
	    Integer z2 = `(let Code<Integer> x2 = <| 0 |>; x2 = <| y |>);
	} |>.run();
    }
}
