import java.io.*;
import java.util.*;

public abstract class Expr {
    public static Expr parse (SExp sexp) {
        // FIXME
        throw new UnsupportedOperationException ("SExp.read not (yet) implemented");
    }

    public static Expr parse (Reader in) throws IOException {
        SExp sexp = SExp.read (in);
        return parse (sexp);
    }

    public static Expr parse (String s) throws IOException {
        return parse (new StringReader (s));
    }


    /* Now we define the kinds of expressions */

    /* an integer literal */
    public class IntLit extends Expr {
        int val;
        public IntLit (int val) {
            this.val = val;
        }
    }

    /* a variable */
    public class Var extends Expr {
        String id;
        public IntLit (String id) {
            this.id = id;
        }
    }

    /* a binary operation, such as plus or times */
    public class BinOp extends Expr {
        Expr left, right;
        Op op;

        public BinOp (Expr left, Expr right, Op op) {
            this.left = left;
            this.right = right;
            this.op = op;
        }

        enum Op { PLUS, MINUS, TIMES, DIV };
    }

    /* a test if a value equals 0 */
    public class IfZero extends Expr {
        Expr test, if_branch, else_branch;

        public Apply (Expr test, Expr if_branch, Expr else_branch) {
            this.test = test;
            this.if_branch = if_branch;
            this.else_branch = else_branch;
        }
    }

    /* an application of a function to arguments */
    public class Apply extends Expr {
        String fun_name;
        List<Expr> args;

        public Apply (String fun_name, List<Expr> args) {
            this.fun_name = fun_name;
            this.args = args;
        }
    }
}
