import java.util.*;
import java.io.*;

/*
 * This class represents s-expressions, which are either:
 * - an identifier, which is a single word
 * - a number
 * - a list of s-expressions of the form (s1 ... sn)
 * For example, (+ 1 2) is an s-expression that is a list, and contains an identifier
 * for + and the numbers 1 and 2. */

public abstract class SExp {
    /* read parses an s-expression from an input */
    public static SExp read (Reader in) throws IOException {
        // FIXME
        throw new UnsupportedOperationException ("SExp.read not (yet) implemented");
    }

    public static SExp read (String s) throws IOException {
        return read (new StringReader (s));
    }

    public class Ident extends SExp {
        public String id;

        public Ident (String id) {
            this.id = id;
        }
    }

    public class Num extends SExp {
        public int val;

        public Num (int val) {
            this.val = val;
        }
    }

    public class SExpList extends SExp {
        public List<SExp> elems;

        public SExpList (List<SExp> elems) {
            this.elems = elems;
        }
    }
}
