/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.comp;

import edu.rice.cs.mint.comp.com.sun.tools.javac.comp.AttrContext;
import edu.rice.cs.mint.comp.com.sun.tools.javac.comp.Env;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Context;
import edu.rice.cs.mint.comp.javax.tools.JavaFileObject;
import java.util.AbstractQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class Todo
extends AbstractQueue<Env<AttrContext>> {
    protected static final Context.Key<Todo> todoKey = new Context.Key();
    LinkedList<Env<AttrContext>> contents = new LinkedList();
    LinkedList<Queue<Env<AttrContext>>> contentsByFile;
    Map<JavaFileObject, FileQueue> fileMap;

    public static Todo instance(Context context) {
        Todo todo = context.get(todoKey);
        if (todo == null) {
            todo = new Todo(context);
        }
        return todo;
    }

    protected Todo(Context context) {
        context.put(todoKey, this);
    }

    public void append(Env<AttrContext> env) {
        this.add(env);
    }

    @Override
    public Iterator<Env<AttrContext>> iterator() {
        return this.contents.iterator();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean offer(Env<AttrContext> env) {
        if (this.contents.add(env)) {
            if (this.contentsByFile != null) {
                this.addByFile(env);
            }
            return true;
        }
        return false;
    }

    @Override
    public Env<AttrContext> poll() {
        if (this.size() == 0) {
            return null;
        }
        Env<AttrContext> env = this.contents.remove(0);
        if (this.contentsByFile != null) {
            this.removeByFile(env);
        }
        return env;
    }

    @Override
    public Env<AttrContext> peek() {
        return this.size() == 0 ? null : this.contents.get(0);
    }

    public Queue<Queue<Env<AttrContext>>> groupByFile() {
        if (this.contentsByFile == null) {
            this.contentsByFile = new LinkedList();
            for (Env env : this.contents) {
                this.addByFile(env);
            }
        }
        return this.contentsByFile;
    }

    private void addByFile(Env<AttrContext> env) {
        FileQueue fileQueue;
        JavaFileObject javaFileObject = env.toplevel.sourcefile;
        if (this.fileMap == null) {
            this.fileMap = new HashMap<JavaFileObject, FileQueue>();
        }
        if ((fileQueue = this.fileMap.get(javaFileObject)) == null) {
            fileQueue = new FileQueue();
            this.fileMap.put(javaFileObject, fileQueue);
            this.contentsByFile.add(fileQueue);
        }
        fileQueue.fileContents.add(env);
    }

    private void removeByFile(Env<AttrContext> env) {
        JavaFileObject javaFileObject = env.toplevel.sourcefile;
        FileQueue fileQueue = this.fileMap.get(javaFileObject);
        if (fileQueue == null) {
            return;
        }
        if (fileQueue.fileContents.remove(env) && fileQueue.isEmpty()) {
            this.fileMap.remove(javaFileObject);
            this.contentsByFile.remove(fileQueue);
        }
    }

    class FileQueue
    extends AbstractQueue<Env<AttrContext>> {
        LinkedList<Env<AttrContext>> fileContents = new LinkedList();

        FileQueue() {
        }

        @Override
        public Iterator<Env<AttrContext>> iterator() {
            return this.fileContents.iterator();
        }

        @Override
        public int size() {
            return this.fileContents.size();
        }

        @Override
        public boolean offer(Env<AttrContext> env) {
            if (this.fileContents.offer(env)) {
                Todo.this.contents.add(env);
                return true;
            }
            return false;
        }

        @Override
        public Env<AttrContext> poll() {
            if (this.fileContents.size() == 0) {
                return null;
            }
            Env<AttrContext> env = this.fileContents.remove(0);
            Todo.this.contents.remove(env);
            return env;
        }

        @Override
        public Env<AttrContext> peek() {
            return this.fileContents.size() == 0 ? null : this.fileContents.get(0);
        }
    }
}

