/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.util;

import edu.rice.cs.mint.comp.com.sun.tools.javac.util.DiagnosticSource;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JCDiagnostic;
import edu.rice.cs.mint.comp.javax.tools.JavaFileObject;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLog {
    protected JCDiagnostic.Factory diags;
    protected DiagnosticSource source;
    protected Map<JavaFileObject, DiagnosticSource> sourceMap;

    AbstractLog(JCDiagnostic.Factory factory) {
        this.diags = factory;
        this.sourceMap = new HashMap<JavaFileObject, DiagnosticSource>();
    }

    public JavaFileObject useSource(JavaFileObject javaFileObject) {
        JavaFileObject javaFileObject2 = this.source == null ? null : this.source.getFile();
        this.source = this.getSource(javaFileObject);
        return javaFileObject2;
    }

    protected DiagnosticSource getSource(JavaFileObject javaFileObject) {
        if (javaFileObject == null) {
            return null;
        }
        DiagnosticSource diagnosticSource = this.sourceMap.get(javaFileObject);
        if (diagnosticSource == null) {
            diagnosticSource = new DiagnosticSource(javaFileObject, this);
            this.sourceMap.put(javaFileObject, diagnosticSource);
        }
        return diagnosticSource;
    }

    public DiagnosticSource currentSource() {
        return this.source;
    }

    public void error(String string, Object ... objectArray) {
        this.report(this.diags.error(this.source, null, string, objectArray));
    }

    public void error(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.error(this.source, diagnosticPosition, string, objectArray));
    }

    public void error(int n, String string, Object ... objectArray) {
        this.report(this.diags.error(this.source, this.wrap(n), string, objectArray));
    }

    public void warning(String string, Object ... objectArray) {
        this.report(this.diags.warning(this.source, null, string, objectArray));
    }

    public void warning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.warning(this.source, diagnosticPosition, string, objectArray));
    }

    public void warning(int n, String string, Object ... objectArray) {
        this.report(this.diags.warning(this.source, this.wrap(n), string, objectArray));
    }

    public void mandatoryWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.mandatoryWarning(this.source, diagnosticPosition, string, objectArray));
    }

    public void note(String string, Object ... objectArray) {
        this.report(this.diags.note(this.source, null, string, objectArray));
    }

    public void note(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.note(this.source, diagnosticPosition, string, objectArray));
    }

    public void note(int n, String string, Object ... objectArray) {
        this.report(this.diags.note(this.source, this.wrap(n), string, objectArray));
    }

    public void note(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        this.report(this.diags.note(this.getSource(javaFileObject), null, string, objectArray));
    }

    public void mandatoryNote(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        this.report(this.diags.mandatoryNote(this.getSource(javaFileObject), string, objectArray));
    }

    protected abstract void report(JCDiagnostic var1);

    protected abstract void directError(String var1, Object ... var2);

    private JCDiagnostic.DiagnosticPosition wrap(int n) {
        return n == -1 ? null : new JCDiagnostic.SimpleDiagnosticPosition(n);
    }
}

