/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.runtime;

import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.CouldNotLoadCodeException;
import edu.rice.cs.mint.runtime.CouldNotSaveCodeException;
import edu.rice.cs.mint.runtime.HashMapClassLoader;
import edu.rice.cs.mint.runtime.InternalError;
import edu.rice.cs.mint.runtime.MSPTreeCode;
import edu.rice.cs.mint.runtime.StringCodeCompiler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class MintSerializer {
    public static PrintStream out = System.out;
    public static final String MANIFEST_MAIN_CLASS_KEY = "edu-rice-cs-mint-runtime-MintSerializer-main-class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> void save(Code<X> code, String string, File file, Options ... optionsArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            MintSerializer.save(code, string, fileOutputStream, optionsArray);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static <X> void save(Code<X> code, String string, String string2) throws IOException {
        MintSerializer.save(code, string, string2);
    }

    public static <X> void save(Code<X> code, String string, String string2, Options ... optionsArray) throws IOException {
        MintSerializer.save(code, string, new File(string2), optionsArray);
    }

    public static <X> void save(Code<X> code, String string, OutputStream outputStream) throws IOException {
        MintSerializer.save(code, string, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> void save(Code<X> code, String string, OutputStream outputStream, Options ... optionsArray) throws IOException {
        EnumSet<Options> enumSet = optionsArray.length > 0 ? EnumSet.copyOf(Arrays.asList(optionsArray)) : EnumSet.noneOf(Options.class);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Manifest-Version: 1.0\n");
        stringBuilder.append("edu-rice-cs-mint-runtime-MintSerializer-main-class: ").append(string).append("\n");
        if (enumSet.contains((Object)Options.MAIN_METHOD)) {
            stringBuilder.append("Main-Class: " + string + "$Main\n");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
        Manifest manifest = new Manifest(byteArrayInputStream);
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream, manifest);
        try {
            Object object;
            Object object3;
            MSPTreeCode.ClassInfo classInfo;
            if (!(code instanceof MSPTreeCode)) {
                classInfo = MintSerializer.getFromCompiledCode(code, string);
            } else {
                if (HashMapClassLoader.instance().getClassBytes(string) != null) {
                    throw new CouldNotSaveCodeException("A class with name " + string + " already exists");
                }
                try {
                    if (HashMapClassLoader.instance().loadClass(string) != null) {
                        throw new CouldNotSaveCodeException("A class with name " + string + " already exists");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                object3 = (MSPTreeCode)code;
                classInfo = ((MSPTreeCode)object3).generateClass(string);
                if (enumSet.contains((Object)Options.VERBOSE)) {
                    out.println("======= Saving " + string + " =======");
                    out.println(classInfo.text);
                    out.println("======^ Saving " + string + " ^======");
                }
            }
            if (classInfo.bytes_hash.size() == 0) {
                throw new CouldNotSaveCodeException("Class could not be compiled");
            }
            for (Map.Entry object22 : classInfo.bytes_hash.entrySet()) {
                byte[] i = (byte[])object22.getValue();
                object = new JarEntry((String)object22.getKey() + ".class");
                jarOutputStream.putNextEntry((ZipEntry)object);
                jarOutputStream.write(i, 0, i.length);
            }
            object3 = new JarEntry(string + ".csp");
            jarOutputStream.putNextEntry((ZipEntry)object3);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(jarOutputStream);
            objectOutputStream.writeInt(classInfo.csp_table.length);
            for (int i = 0; i < classInfo.csp_table.length; ++i) {
                if (!(classInfo.csp_table[i] instanceof Serializable)) {
                    throw new CouldNotSaveCodeException("CSP table entry " + i + " is not serializable: " + classInfo.csp_table[i] + " (instance of " + classInfo.csp_table[i].getClass().getName() + ")");
                }
                object = (Serializable)classInfo.csp_table[i];
                try {
                    objectOutputStream.writeObject(object);
                    continue;
                }
                catch (InvalidClassException notSerializableException) {
                    throw new CouldNotSaveCodeException("CSP table entry " + i + " is not serializable: " + classInfo.csp_table[i] + " (instance of " + classInfo.csp_table[i].getClass().getName() + ")", notSerializableException);
                }
                catch (NotSerializableException notSerializableException) {
                    throw new CouldNotSaveCodeException("CSP table entry " + i + " is not serializable: " + classInfo.csp_table[i] + " (instance of " + classInfo.csp_table[i].getClass().getName() + ")", notSerializableException);
                }
            }
            objectOutputStream.flush();
            if (enumSet.contains((Object)Options.MAIN_METHOD)) {
                MintSerializer.addClassWithMainMethod(string, jarOutputStream);
            }
            jarOutputStream.flush();
        }
        finally {
            jarOutputStream.close();
            outputStream.flush();
        }
    }

    protected static void addClassWithMainMethod(String string, JarOutputStream jarOutputStream) throws IOException {
        String string2 = string + "$Main";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("import java.io.*;\npublic class " + string2 + " {\n" + "  public static void main(String[] args) throws Exception {\n" + "    InputStream is = " + string2 + ".class.getResourceAsStream(\"" + string + ".csp\");\n" + "    ObjectInputStream ois = new ObjectInputStream(is);\n" + "    int csp_length = ois.readInt();\n" + "    Object[] csp_table = new Object[csp_length];\n" + "    for(int i=0; i<csp_length; ++i) {\n" + "      csp_table[i] = ois.readObject();\n" + "    }\n" + "    System.out.println(new " + string + "(csp_table).run());\n" + "  }\n" + "}");
        StringCodeCompiler stringCodeCompiler = (StringCodeCompiler)StringCodeCompiler.instance(MSPTreeCode.context);
        edu.rice.cs.mint.comp.com.sun.tools.javac.util.Options options = edu.rice.cs.mint.comp.com.sun.tools.javac.util.Options.instance(MSPTreeCode.context);
        options.put("-classpath", HashMapClassLoader.instance().getClassPathPropertyValue());
        HashMap<String, byte[]> hashMap = stringCodeCompiler.compileStringToBytes(string + "$Main", stringBuilder.toString());
        for (Map.Entry<String, byte[]> entry : hashMap.entrySet()) {
            byte[] byArray = entry.getValue();
            JarEntry jarEntry = new JarEntry(entry.getKey() + ".class");
            jarOutputStream.putNextEntry(jarEntry);
            jarOutputStream.write(byArray, 0, byArray.length);
        }
    }

    protected static <X> MSPTreeCode.ClassInfo getFromCompiledCode(Code<X> code, String string) throws IOException {
        MSPTreeCode.ClassInfo classInfo = new MSPTreeCode.ClassInfo();
        byte[] byArray = HashMapClassLoader.instance().getClassBytes(code.getClass().getName());
        if (byArray == null) {
            throw new CouldNotSaveCodeException("Code was already compiled, but class could not be found: " + code.getClass().getName());
        }
        if (!code.getClass().getName().equals(string)) {
            throw new CouldNotSaveCodeException("Code was already compiled with name " + code.getClass().getName() + ", cannot save it with different name " + string);
        }
        classInfo.bytes_hash = new HashMap();
        classInfo.bytes_hash.put(code.getClass().getName(), byArray);
        classInfo.csp_table = new Object[0];
        return classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <X> Code<X> loadCode(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Code<X> code = MintSerializer.loadCode(fileInputStream);
            return code;
        }
        finally {
            fileInputStream.close();
        }
    }

    protected static <X> Code<X> loadCode(String string) throws IOException {
        return MintSerializer.loadCode(new File(string));
    }

    protected static <X> Code<X> loadCode(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        byte[] byArray = new byte[1024];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        JarInputStream jarInputStream = new JarInputStream(bufferedInputStream);
        Manifest manifest = jarInputStream.getManifest();
        String string = null;
        Object[] objectArray = null;
        Attributes attributes = manifest.getMainAttributes();
        Object object3 = attributes.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (Attributes.Name)object3.next();
            object = attributes.getValue((Attributes.Name)object2);
            if (!((Attributes.Name)object2).toString().equals(MANIFEST_MAIN_CLASS_KEY)) continue;
            string = object;
        }
        if (string == null) {
            throw new CouldNotLoadCodeException("Main class name not set in manifest file");
        }
        object2 = new HashMap();
        while ((object3 = jarInputStream.getNextJarEntry()) != null) {
            int n;
            Closeable closeable;
            object = ((ZipEntry)object3).getName();
            if (((String)object).equals(string + ".csp")) {
                closeable = new ObjectInputStream(jarInputStream);
                n = ((ObjectInputStream)closeable).readInt();
                objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    try {
                        objectArray[i] = ((ObjectInputStream)closeable).readObject();
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new CouldNotLoadCodeException("CSP table entry " + i + " could not be deserialized", classNotFoundException);
                    }
                }
                continue;
            }
            if (!((String)object).endsWith(".class")) continue;
            closeable = new ByteArrayOutputStream();
            n = 0;
            while ((n = jarInputStream.read(byArray, 0, 1024)) >= 0) {
                ((ByteArrayOutputStream)closeable).write(byArray, 0, n);
            }
            byte[] byArray2 = ((ByteArrayOutputStream)closeable).toByteArray();
            ((HashMap)object2).put(((String)object).substring(0, ((String)object).length() - ".class".length()), byArray2);
        }
        if (objectArray == null) {
            throw new CouldNotLoadCodeException("CSP table not found, file " + string + ".csp missing");
        }
        try {
            object = MSPTreeCode.loadClassAndCreateInstance(string, (HashMap<String, byte[]>)object2, objectArray);
            return object;
        }
        catch (InternalError internalError) {
            throw new CouldNotLoadCodeException(internalError.getMessage(), internalError.getCause());
        }
    }

    public static <X> X load(InputStream inputStream) throws IOException {
        return MintSerializer.loadCode(inputStream).run();
    }

    public static <X> X load(File file) throws IOException {
        return MintSerializer.loadCode(file).run();
    }

    public static <X> X load(String string) throws IOException {
        return MintSerializer.loadCode(string).run();
    }

    public static enum Options {
        MAIN_METHOD,
        VERBOSE;

    }
}

