/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.classfile;

import edu.rice.cs.mint.comp.com.sun.tools.classfile.ClassReader;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ConstantPool;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ConstantPoolException;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.DescriptorException;
import java.io.IOException;

public class Descriptor {
    public final int index;
    private int count;

    public Descriptor(ClassReader classReader) throws IOException {
        this(classReader.readUnsignedShort());
    }

    public Descriptor(int n) {
        this.index = n;
    }

    public String getValue(ConstantPool constantPool) throws ConstantPoolException {
        return constantPool.getUTF8Value(this.index);
    }

    public int getParameterCount(ConstantPool constantPool) throws ConstantPoolException, InvalidDescriptor {
        String string = this.getValue(constantPool);
        int n = string.indexOf(")");
        if (n == -1) {
            throw new InvalidDescriptor(string);
        }
        this.parse(string, 0, n + 1);
        return this.count;
    }

    public String getParameterTypes(ConstantPool constantPool) throws ConstantPoolException, InvalidDescriptor {
        String string = this.getValue(constantPool);
        int n = string.indexOf(")");
        if (n == -1) {
            throw new InvalidDescriptor(string);
        }
        return this.parse(string, 0, n + 1);
    }

    public String getReturnType(ConstantPool constantPool) throws ConstantPoolException, InvalidDescriptor {
        String string = this.getValue(constantPool);
        int n = string.indexOf(")");
        if (n == -1) {
            throw new InvalidDescriptor(string);
        }
        return this.parse(string, n + 1, string.length());
    }

    public String getFieldType(ConstantPool constantPool) throws ConstantPoolException, InvalidDescriptor {
        String string = this.getValue(constantPool);
        return this.parse(string, 0, string.length());
    }

    private String parse(String string, int n, int n2) throws InvalidDescriptor {
        int n3 = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        this.count = 0;
        block15: while (n3 < n2) {
            String string2;
            char c = string.charAt(n3++);
            switch (c) {
                case '(': {
                    stringBuffer.append('(');
                    continue block15;
                }
                case ')': {
                    stringBuffer.append(')');
                    continue block15;
                }
                case '[': {
                    ++n4;
                    continue block15;
                }
                case 'B': {
                    string2 = "byte";
                    break;
                }
                case 'C': {
                    string2 = "char";
                    break;
                }
                case 'D': {
                    string2 = "double";
                    break;
                }
                case 'F': {
                    string2 = "float";
                    break;
                }
                case 'I': {
                    string2 = "int";
                    break;
                }
                case 'J': {
                    string2 = "long";
                    break;
                }
                case 'L': {
                    int n5 = string.indexOf(59, n3);
                    if (n5 == -1) {
                        throw new InvalidDescriptor(string, n3 - 1);
                    }
                    string2 = string.substring(n3, n5).replace('/', '.');
                    n3 = n5 + 1;
                    break;
                }
                case 'S': {
                    string2 = "short";
                    break;
                }
                case 'Z': {
                    string2 = "boolean";
                    break;
                }
                case 'V': {
                    string2 = "void";
                    break;
                }
                default: {
                    throw new InvalidDescriptor(string, n3 - 1);
                }
            }
            if (stringBuffer.length() > 1 && stringBuffer.charAt(0) == '(') {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
            while (n4 > 0) {
                stringBuffer.append("[]");
                --n4;
            }
            ++this.count;
        }
        return stringBuffer.toString();
    }

    public class InvalidDescriptor
    extends DescriptorException {
        private static final long serialVersionUID = 1L;
        public final String desc;
        public final int index;

        InvalidDescriptor(String string) {
            this.desc = string;
            this.index = -1;
        }

        InvalidDescriptor(String string, int n) {
            this.desc = string;
            this.index = n;
        }

        public String getMessage() {
            if (this.index == -1) {
                return "invalid descriptor \"" + this.desc + "\"";
            }
            return "descriptor is invalid at offset " + this.index + " in \"" + this.desc + "\"";
        }
    }
}

