/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.tree;

import edu.rice.cs.mint.comp.com.sun.tools.javac.code.BoundKind;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symbol;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.JCTree;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.TreeInfo;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.TreeScanner;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Convert;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.List;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.ListBuffer;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pretty
extends JCTree.Visitor {
    private final boolean sourceOutput;
    Writer out;
    public int width = 4;
    protected int lmargin = 0;
    Name enclClassName;
    Map<JCTree, String> docComments = null;
    protected String lineSep = System.getProperty("line.separator");
    int prec;

    public Pretty(Writer writer, boolean bl) {
        this.out = writer;
        this.sourceOutput = bl;
    }

    protected void align() throws IOException {
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.write(" ");
        }
    }

    protected void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    protected void open(int n, int n2) throws IOException {
        if (n2 < n) {
            this.out.write("(");
        }
    }

    protected void close(int n, int n2) throws IOException {
        if (n2 < n) {
            this.out.write(")");
        }
    }

    public void print(Object object) throws IOException {
        this.out.write(Convert.escapeUnicode(object.toString()));
    }

    public void println() throws IOException {
        this.out.write(this.lineSep);
    }

    public void printExpr(JCTree jCTree, int n) throws IOException {
        int n2 = this.prec;
        try {
            block5: {
                try {
                    this.prec = n;
                    if (jCTree == null) {
                        this.print("/*missing*/");
                        break block5;
                    }
                    jCTree.accept(this);
                }
                catch (UncheckedIOException uncheckedIOException) {
                    IOException iOException = new IOException(uncheckedIOException.getMessage());
                    iOException.initCause(uncheckedIOException);
                    throw iOException;
                }
            }
            Object var7_4 = null;
            this.prec = n2;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.prec = n2;
            throw throwable;
        }
    }

    public void printExpr(JCTree jCTree) throws IOException {
        this.printExpr(jCTree, 0);
    }

    public void printStat(JCTree jCTree) throws IOException {
        this.printExpr(jCTree, -1);
    }

    public <T extends JCTree> void printExprs(List<T> list, String string) throws IOException {
        if (list.nonEmpty()) {
            this.printExpr((JCTree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                this.print(string);
                this.printExpr((JCTree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    public <T extends JCTree> void printExprs(List<T> list) throws IOException {
        this.printExprs(list, ", ");
    }

    public void printStats(List<? extends JCTree> list) throws IOException {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.align();
            this.printStat((JCTree)list2.head);
            this.println();
            list2 = list2.tail;
        }
    }

    public void printFlags(long l) throws IOException {
        if ((l & 0x1000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(l));
        if ((l & 0x8FFFL) != 0L) {
            this.print(" ");
        }
        if ((l & 0x2000L) != 0L) {
            this.print("@");
        }
    }

    public void printAnnotations(List<JCTree.JCAnnotation> list) throws IOException {
        List<JCTree.JCAnnotation> list2 = list;
        while (list2.nonEmpty()) {
            this.printStat((JCTree)list2.head);
            this.println();
            this.align();
            list2 = list2.tail;
        }
    }

    public void printDocComment(JCTree jCTree) throws IOException {
        String string;
        if (this.docComments != null && (string = this.docComments.get(jCTree)) != null) {
            this.print("/**");
            this.println();
            int n = 0;
            int n2 = Pretty.lineEndPos(string, n);
            while (n < string.length()) {
                this.align();
                this.print(" *");
                if (n < string.length() && string.charAt(n) > ' ') {
                    this.print(" ");
                }
                this.print(string.substring(n, n2));
                this.println();
                n = n2 + 1;
                n2 = Pretty.lineEndPos(string, n);
            }
            this.align();
            this.print(" */");
            this.println();
            this.align();
        }
    }

    static int lineEndPos(String string, int n) {
        int n2 = string.indexOf(10, n);
        if (n2 < 0) {
            n2 = string.length();
        }
        return n2;
    }

    public void printTypeParameters(List<JCTree.JCTypeParameter> list) throws IOException {
        if (list.nonEmpty()) {
            this.print("<");
            this.printExprs(list);
            this.print(">");
        }
    }

    public void printBlock(List<? extends JCTree> list) throws IOException {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(list);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printEnumBody(List<JCTree> list) throws IOException {
        this.print("{");
        this.println();
        this.indent();
        boolean bl = true;
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            if (this.isEnumerator((JCTree)list2.head)) {
                if (!bl) {
                    this.print(",");
                    this.println();
                }
                this.align();
                this.printStat((JCTree)list2.head);
                bl = false;
            }
            list2 = list2.tail;
        }
        this.print(";");
        this.println();
        list2 = list;
        while (list2.nonEmpty()) {
            if (!this.isEnumerator((JCTree)list2.head)) {
                this.align();
                this.printStat((JCTree)list2.head);
                this.println();
            }
            list2 = list2.tail;
        }
        this.undent();
        this.align();
        this.print("}");
    }

    boolean isEnumerator(JCTree jCTree) {
        return jCTree.getTag() == 5 && (((JCTree.JCVariableDecl)jCTree).mods.flags & 0x4000L) != 0L;
    }

    public void printUnit(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCClassDecl jCClassDecl) throws IOException {
        this.docComments = jCCompilationUnit.docComments;
        this.printDocComment(jCCompilationUnit);
        if (jCCompilationUnit.pid != null) {
            this.print("package ");
            this.printExpr(jCCompilationUnit.pid);
            this.print(";");
            this.println();
        }
        boolean bl = true;
        List<JCTree> list = jCCompilationUnit.defs;
        while (list.nonEmpty() && (jCClassDecl == null || ((JCTree)list.head).getTag() == 2)) {
            if (((JCTree)list.head).getTag() == 2) {
                JCTree.JCImport jCImport = (JCTree.JCImport)list.head;
                Name name = TreeInfo.name(jCImport.qualid);
                if (name == name.table.names.asterisk || jCClassDecl == null || this.isUsed(TreeInfo.symbol(jCImport.qualid), jCClassDecl)) {
                    if (bl) {
                        bl = false;
                        this.println();
                    }
                    this.printStat(jCImport);
                }
            } else {
                this.printStat((JCTree)list.head);
            }
            list = list.tail;
        }
        if (jCClassDecl != null) {
            this.printStat(jCClassDecl);
            this.println();
        }
    }

    boolean isUsed(final Symbol symbol, JCTree jCTree) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UsedVisitor
        extends TreeScanner {
            boolean result = false;

            UsedVisitor() {
            }

            @Override
            public void scan(JCTree jCTree) {
                if (jCTree != null && !this.result) {
                    jCTree.accept(this);
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                if (jCIdent.sym == symbol) {
                    this.result = true;
                }
            }
        }
        UsedVisitor usedVisitor = new UsedVisitor();
        usedVisitor.scan(jCTree);
        return usedVisitor.result;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        try {
            this.printUnit(jCCompilationUnit, null);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitImport(JCTree.JCImport jCImport) {
        try {
            this.print("import ");
            if (jCImport.staticImport) {
                this.print("static ");
            }
            this.printExpr(jCImport.qualid);
            this.print(";");
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        try {
            this.println();
            this.align();
            this.printDocComment(jCClassDecl);
            this.printAnnotations(jCClassDecl.mods.annotations);
            this.printFlags(jCClassDecl.mods.flags & 0xFFFFFFFFFFFFFDFFL);
            Name name = this.enclClassName;
            this.enclClassName = jCClassDecl.name;
            if ((jCClassDecl.mods.flags & 0x200L) != 0L) {
                this.print("interface " + jCClassDecl.name);
                this.printTypeParameters(jCClassDecl.typarams);
                if (jCClassDecl.implementing.nonEmpty()) {
                    this.print(" extends ");
                    this.printExprs(jCClassDecl.implementing);
                }
            } else {
                if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
                    this.print("enum " + jCClassDecl.name);
                } else {
                    this.print("class " + jCClassDecl.name);
                }
                this.printTypeParameters(jCClassDecl.typarams);
                if (jCClassDecl.extending != null) {
                    this.print(" extends ");
                    this.printExpr(jCClassDecl.extending);
                }
                if (jCClassDecl.implementing.nonEmpty()) {
                    this.print(" implements ");
                    this.printExprs(jCClassDecl.implementing);
                }
            }
            this.print(" ");
            if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
                this.printEnumBody(jCClassDecl.defs);
            } else {
                this.printBlock(jCClassDecl.defs);
            }
            this.enclClassName = name;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        try {
            if (jCMethodDecl.name == jCMethodDecl.name.table.names.init && this.enclClassName == null && this.sourceOutput) {
                return;
            }
            this.println();
            this.align();
            this.printDocComment(jCMethodDecl);
            this.printExpr(jCMethodDecl.mods);
            this.printTypeParameters(jCMethodDecl.typarams);
            if (jCMethodDecl.name == jCMethodDecl.name.table.names.init) {
                this.print(this.enclClassName != null ? this.enclClassName : jCMethodDecl.name);
            } else {
                this.printExpr(jCMethodDecl.restype);
                this.print(" " + jCMethodDecl.name);
            }
            this.print("(");
            this.printExprs(jCMethodDecl.params);
            this.print(")");
            if (jCMethodDecl.thrown.nonEmpty()) {
                this.print(" throws ");
                this.printExprs(jCMethodDecl.thrown);
            }
            if (jCMethodDecl.body != null) {
                this.print(" ");
                this.printStat(jCMethodDecl.body);
            } else {
                this.print(";");
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        try {
            if (this.docComments != null && this.docComments.get(jCVariableDecl) != null) {
                this.println();
                this.align();
            }
            this.printDocComment(jCVariableDecl);
            if ((jCVariableDecl.mods.flags & 0x4000L) != 0L) {
                this.print("/*public static final*/ ");
                this.printVarDefName(jCVariableDecl);
                if (jCVariableDecl.init != null) {
                    this.print(" /* = ");
                    this.printExpr(jCVariableDecl.init);
                    this.print(" */");
                }
            } else {
                this.printExpr(jCVariableDecl.mods);
                if ((jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
                    this.printExpr(((JCTree.JCArrayTypeTree)jCVariableDecl.vartype).elemtype);
                    this.print("... ");
                    this.printVarDefName(jCVariableDecl);
                } else {
                    this.printExpr(jCVariableDecl.vartype);
                    this.print(" ");
                    this.printVarDefName(jCVariableDecl);
                }
                if (jCVariableDecl.init != null) {
                    this.print(" = ");
                    this.printExpr(jCVariableDecl.init);
                }
                if (this.prec == -1) {
                    this.print(";");
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public void printVarDefName(JCTree.JCVariableDecl jCVariableDecl) throws IOException {
        this.print(jCVariableDecl.name);
    }

    @Override
    public void visitSkip(JCTree.JCSkip jCSkip) {
        try {
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        try {
            this.printFlags(jCBlock.flags);
            this.printBlock(jCBlock.stats);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBracketExpr(JCTree.JCBracketExpr jCBracketExpr) {
        try {
            this.print("<|");
            this.printStat(jCBracketExpr.body);
            this.print("|>");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBracketStat(JCTree.JCBracketStat jCBracketStat) {
        try {
            this.print("<|{ ");
            this.printBlock(jCBracketStat.body);
            this.print("} |>");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitEscapeExpr(JCTree.JCEscapeExpr jCEscapeExpr) {
        try {
            this.print("`(");
            this.printExpr(jCEscapeExpr.body);
            this.print(")");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitEscapeStat(JCTree.JCEscapeStat jCEscapeStat) {
        try {
            this.print("`(");
            this.printExpr(jCEscapeStat.body);
            this.print(");");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        try {
            this.print("do ");
            this.printStat(jCDoWhileLoop.body);
            this.align();
            this.print(" while ");
            if (jCDoWhileLoop.cond.getTag() == 29) {
                this.printExpr(jCDoWhileLoop.cond);
            } else {
                this.print("(");
                this.printExpr(jCDoWhileLoop.cond);
                this.print(")");
            }
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        try {
            this.print("while ");
            if (jCWhileLoop.cond.getTag() == 29) {
                this.printExpr(jCWhileLoop.cond);
            } else {
                this.print("(");
                this.printExpr(jCWhileLoop.cond);
                this.print(")");
            }
            this.print(" ");
            this.printStat(jCWhileLoop.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        try {
            this.print("for (");
            if (jCForLoop.init.nonEmpty()) {
                if (((JCTree.JCStatement)jCForLoop.init.head).getTag() == 5) {
                    this.printExpr((JCTree)jCForLoop.init.head);
                    List list = jCForLoop.init.tail;
                    while (list.nonEmpty()) {
                        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                        this.print(", " + jCVariableDecl.name + " = ");
                        this.printExpr(jCVariableDecl.init);
                        list = list.tail;
                    }
                } else {
                    this.printExprs(jCForLoop.init);
                }
            }
            this.print("; ");
            if (jCForLoop.cond != null) {
                this.printExpr(jCForLoop.cond);
            }
            this.print("; ");
            this.printExprs(jCForLoop.step);
            this.print(") ");
            this.printStat(jCForLoop.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        try {
            this.print("for (");
            this.printExpr(jCEnhancedForLoop.var);
            this.print(" : ");
            this.printExpr(jCEnhancedForLoop.expr);
            this.print(") ");
            this.printStat(jCEnhancedForLoop.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        try {
            this.print(jCLabeledStatement.label + ": ");
            this.printStat(jCLabeledStatement.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        try {
            this.print("switch ");
            if (jCSwitch.selector.getTag() == 29) {
                this.printExpr(jCSwitch.selector);
            } else {
                this.print("(");
                this.printExpr(jCSwitch.selector);
                this.print(")");
            }
            this.print(" {");
            this.println();
            this.printStats(jCSwitch.cases);
            this.align();
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitCase(JCTree.JCCase jCCase) {
        try {
            if (jCCase.pat == null) {
                this.print("default");
            } else {
                this.print("case ");
                this.printExpr(jCCase.pat);
            }
            this.print(": ");
            this.println();
            this.indent();
            this.printStats(jCCase.stats);
            this.undent();
            this.align();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        try {
            this.print("synchronized ");
            if (jCSynchronized.lock.getTag() == 29) {
                this.printExpr(jCSynchronized.lock);
            } else {
                this.print("(");
                this.printExpr(jCSynchronized.lock);
                this.print(")");
            }
            this.print(" ");
            this.printStat(jCSynchronized.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTry(JCTree.JCTry jCTry) {
        try {
            this.print("try ");
            this.printStat(jCTry.body);
            List<JCTree.JCCatch> list = jCTry.catchers;
            while (list.nonEmpty()) {
                this.printStat((JCTree)list.head);
                list = list.tail;
            }
            if (jCTry.finalizer != null) {
                this.print(" finally ");
                this.printStat(jCTry.finalizer);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch jCCatch) {
        try {
            this.print(" catch (");
            this.printExpr(jCCatch.param);
            this.print(") ");
            this.printStat(jCCatch.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        try {
            this.open(this.prec, 3);
            this.printExpr(jCConditional.cond, 3);
            this.print(" ? ");
            this.printExpr(jCConditional.truepart, 3);
            this.print(" : ");
            this.printExpr(jCConditional.falsepart, 3);
            this.close(this.prec, 3);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        try {
            this.print("if ");
            if (jCIf.cond.getTag() == 29) {
                this.printExpr(jCIf.cond);
            } else {
                this.print("(");
                this.printExpr(jCIf.cond);
                this.print(")");
            }
            this.print(" ");
            this.printStat(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                this.print(" else ");
                this.printStat(jCIf.elsepart);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        try {
            this.printExpr(jCExpressionStatement.expr);
            if (this.prec == -1) {
                this.print(";");
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
        try {
            this.print("break");
            if (jCBreak.label != null) {
                this.print(" " + jCBreak.label);
            }
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
        try {
            this.print("continue");
            if (jCContinue.label != null) {
                this.print(" " + jCContinue.label);
            }
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        try {
            this.print("return");
            if (jCReturn.expr != null) {
                this.print(" ");
                this.printExpr(jCReturn.expr);
            }
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        try {
            this.print("throw ");
            this.printExpr(jCThrow.expr);
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAssert(JCTree.JCAssert jCAssert) {
        try {
            this.print("assert ");
            this.printExpr(jCAssert.cond);
            if (jCAssert.detail != null) {
                this.print(" : ");
                this.printExpr(jCAssert.detail);
            }
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        try {
            if (!jCMethodInvocation.typeargs.isEmpty()) {
                if (jCMethodInvocation.meth.getTag() == 34) {
                    JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCMethodInvocation.meth;
                    this.printExpr(jCFieldAccess.selected);
                    this.print(".<");
                    this.printExprs(jCMethodInvocation.typeargs);
                    this.print(">" + jCFieldAccess.name);
                } else {
                    this.print("<");
                    this.printExprs(jCMethodInvocation.typeargs);
                    this.print(">");
                    this.printExpr(jCMethodInvocation.meth);
                }
            } else {
                this.printExpr(jCMethodInvocation.meth);
            }
            this.print("(");
            this.printExprs(jCMethodInvocation.args);
            this.print(")");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        try {
            if (jCNewClass.encl != null) {
                this.printExpr(jCNewClass.encl);
                this.print(".");
            }
            this.print("new ");
            if (!jCNewClass.typeargs.isEmpty()) {
                this.print("<");
                this.printExprs(jCNewClass.typeargs);
                this.print(">");
            }
            this.printExpr(jCNewClass.clazz);
            this.print("(");
            this.printExprs(jCNewClass.args);
            this.print(")");
            if (jCNewClass.def != null) {
                Name name = this.enclClassName;
                Name name2 = jCNewClass.def.name != null ? jCNewClass.def.name : (this.enclClassName = jCNewClass.type != null && jCNewClass.type.tsym.name != jCNewClass.type.tsym.name.table.names.empty ? jCNewClass.type.tsym.name : null);
                if ((jCNewClass.def.mods.flags & 0x4000L) != 0L) {
                    this.print("/*enum*/");
                }
                ListBuffer listBuffer = ListBuffer.lb();
                for (JCTree jCTree : jCNewClass.def.defs) {
                    if (jCTree.getTag() == 4) {
                        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                        if (jCMethodDecl.name == jCNewClass.def.name.table.names.init) continue;
                    }
                    listBuffer.add(jCTree);
                }
                this.printBlock(listBuffer.toList());
                this.enclClassName = name;
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        try {
            if (jCNewArray.elemtype != null) {
                this.print("new ");
                JCTree.JCExpression jCExpression = jCNewArray.elemtype;
                if (jCExpression instanceof JCTree.JCArrayTypeTree) {
                    this.printBaseElementType((JCTree.JCArrayTypeTree)jCExpression);
                } else {
                    this.printExpr(jCExpression);
                }
                List<JCTree.JCExpression> list = jCNewArray.dims;
                while (list.nonEmpty()) {
                    this.print("[");
                    this.printExpr((JCTree)list.head);
                    this.print("]");
                    list = list.tail;
                }
                if (jCExpression instanceof JCTree.JCArrayTypeTree) {
                    this.printBrackets((JCTree.JCArrayTypeTree)jCExpression);
                }
            }
            if (jCNewArray.elems != null) {
                if (jCNewArray.elemtype != null) {
                    this.print("[]");
                }
                this.print("{");
                this.printExprs(jCNewArray.elems);
                this.print("}");
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        try {
            this.print("(");
            this.printExpr(jCParens.expr);
            this.print(")");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        try {
            this.open(this.prec, 1);
            this.printExpr(jCAssign.lhs, 2);
            this.print(" = ");
            this.printExpr(jCAssign.rhs, 1);
            this.close(this.prec, 1);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public String operatorName(int n) {
        switch (n) {
            case 46: {
                return "+";
            }
            case 47: {
                return "-";
            }
            case 48: {
                return "!";
            }
            case 49: {
                return "~";
            }
            case 50: {
                return "++";
            }
            case 51: {
                return "--";
            }
            case 52: {
                return "++";
            }
            case 53: {
                return "--";
            }
            case 54: {
                return "<*nullchk*>";
            }
            case 55: {
                return "||";
            }
            case 56: {
                return "&&";
            }
            case 60: {
                return "==";
            }
            case 61: {
                return "!=";
            }
            case 62: {
                return "<";
            }
            case 63: {
                return ">";
            }
            case 64: {
                return "<=";
            }
            case 65: {
                return ">=";
            }
            case 57: {
                return "|";
            }
            case 58: {
                return "^";
            }
            case 59: {
                return "&";
            }
            case 66: {
                return "<<";
            }
            case 67: {
                return ">>";
            }
            case 68: {
                return ">>>";
            }
            case 69: {
                return "+";
            }
            case 70: {
                return "-";
            }
            case 71: {
                return "*";
            }
            case 72: {
                return "/";
            }
            case 73: {
                return "%";
            }
        }
        throw new Error();
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        try {
            this.open(this.prec, 2);
            this.printExpr(jCAssignOp.lhs, 3);
            this.print(" " + this.operatorName(jCAssignOp.getTag() - 17) + "= ");
            this.printExpr(jCAssignOp.rhs, 2);
            this.close(this.prec, 2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        try {
            int n = TreeInfo.opPrec(jCUnary.getTag());
            String string = this.operatorName(jCUnary.getTag());
            this.open(this.prec, n);
            if (jCUnary.getTag() <= 51) {
                this.print(string);
                this.printExpr(jCUnary.arg, n);
            } else {
                this.printExpr(jCUnary.arg, n);
                this.print(string);
            }
            this.close(this.prec, n);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        try {
            int n = TreeInfo.opPrec(jCBinary.getTag());
            String string = this.operatorName(jCBinary.getTag());
            this.open(this.prec, n);
            this.printExpr(jCBinary.lhs, n);
            this.print(" " + string + " ");
            this.printExpr(jCBinary.rhs, n + 1);
            this.close(this.prec, n);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        try {
            this.open(this.prec, 14);
            this.print("(");
            this.printExpr(jCTypeCast.clazz);
            this.print(")");
            this.printExpr(jCTypeCast.expr, 14);
            this.close(this.prec, 14);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        try {
            this.open(this.prec, 10);
            this.printExpr(jCInstanceOf.expr, 10);
            this.print(" instanceof ");
            this.printExpr(jCInstanceOf.clazz, 11);
            this.close(this.prec, 10);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        try {
            this.printExpr(jCArrayAccess.indexed, 15);
            this.print("[");
            this.printExpr(jCArrayAccess.index);
            this.print("]");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        try {
            if (jCFieldAccess.selected instanceof JCTree.JCIdent && ((JCTree.JCIdent)jCFieldAccess.selected).name.toString().equals("")) {
                this.print(jCFieldAccess.name);
            } else {
                this.printExpr(jCFieldAccess.selected, 15);
                this.print("." + jCFieldAccess.name);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        try {
            if (jCIdent.genVarSym != null) {
                this.print("/*genVarSym=" + jCIdent.genVarSym.name + "*/");
            }
            this.print(jCIdent.name);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        try {
            switch (jCLiteral.typetag) {
                case 4: {
                    this.print(jCLiteral.value.toString());
                    break;
                }
                case 5: {
                    this.print(jCLiteral.value + "L");
                    break;
                }
                case 6: {
                    this.print(jCLiteral.value + "F");
                    break;
                }
                case 7: {
                    this.print(jCLiteral.value.toString());
                    break;
                }
                case 2: {
                    this.print("'" + Convert.quote(String.valueOf((char)((Number)jCLiteral.value).intValue())) + "'");
                    break;
                }
                case 8: {
                    this.print(((Number)jCLiteral.value).intValue() == 1 ? "true" : "false");
                    break;
                }
                case 17: {
                    this.print("null");
                    break;
                }
                default: {
                    this.print("\"" + Convert.quote(jCLiteral.value.toString()) + "\"");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        try {
            switch (jCPrimitiveTypeTree.typetag) {
                case 1: {
                    this.print("byte");
                    break;
                }
                case 2: {
                    this.print("char");
                    break;
                }
                case 3: {
                    this.print("short");
                    break;
                }
                case 4: {
                    this.print("int");
                    break;
                }
                case 5: {
                    this.print("long");
                    break;
                }
                case 6: {
                    this.print("float");
                    break;
                }
                case 7: {
                    this.print("double");
                    break;
                }
                case 8: {
                    this.print("boolean");
                    break;
                }
                case 9: {
                    this.print("void");
                    break;
                }
                default: {
                    this.print("error");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        try {
            this.printBaseElementType(jCArrayTypeTree);
            this.printBrackets(jCArrayTypeTree);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void printBaseElementType(JCTree.JCArrayTypeTree jCArrayTypeTree) throws IOException {
        JCTree jCTree = jCArrayTypeTree.elemtype;
        while (jCTree instanceof JCTree.JCWildcard) {
            jCTree = ((JCTree.JCWildcard)jCTree).inner;
        }
        if (jCTree instanceof JCTree.JCArrayTypeTree) {
            this.printBaseElementType((JCTree.JCArrayTypeTree)jCTree);
        } else {
            this.printExpr(jCTree);
        }
    }

    private void printBrackets(JCTree.JCArrayTypeTree jCArrayTypeTree) throws IOException {
        while (true) {
            JCTree.JCExpression jCExpression = jCArrayTypeTree.elemtype;
            this.print("[]");
            if (!(jCExpression instanceof JCTree.JCArrayTypeTree)) break;
            jCArrayTypeTree = (JCTree.JCArrayTypeTree)jCExpression;
        }
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        try {
            this.printExpr(jCTypeApply.clazz);
            this.print("<");
            this.printExprs(jCTypeApply.arguments);
            this.print(">");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        try {
            this.print(jCTypeParameter.name);
            if (jCTypeParameter.bounds.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(jCTypeParameter.bounds, " & ");
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        try {
            this.print(jCWildcard.kind);
            if (jCWildcard.kind.kind != BoundKind.UNBOUND) {
                this.printExpr(jCWildcard.inner);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind typeBoundKind) {
        try {
            this.print(String.valueOf((Object)typeBoundKind.kind));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        try {
            this.print("(ERROR)");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        try {
            this.print("(let ");
            boolean bl = true;
            for (JCTree.JCVariableDecl jCVariableDecl : letExpr.defs) {
                if (bl) {
                    bl = false;
                    this.printExpr(jCVariableDecl, 0);
                    continue;
                }
                this.print(", ");
                this.printVarDefName(jCVariableDecl);
                this.print(" = ");
                this.printExpr(jCVariableDecl.init);
            }
            this.print("; ");
            this.printExpr(letExpr.expr);
            this.print(")");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
        try {
            this.printAnnotations(jCModifiers.annotations);
            this.printFlags(jCModifiers.flags);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
        try {
            this.print("@");
            this.printExpr(jCAnnotation.annotationType);
            this.print("(");
            this.printExprs(jCAnnotation.args);
            this.print(")");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTree(JCTree jCTree) {
        try {
            this.print("(UNKNOWN: " + jCTree.getClass().getName() + ")");
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    protected static class UncheckedIOException
    extends Error {
        static final long serialVersionUID = -4032692679158424751L;

        public UncheckedIOException(IOException iOException) {
            super(iOException.getMessage(), iOException);
        }
    }
}

