/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.javax.tools;

import edu.rice.cs.mint.comp.javax.tools.JavaCompiler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolProvider {
    private static final String propertyName = "sun.tools.ToolProvider";
    private static final String loggerName = "edu.rice.cs.mint.comp.javax.tools";

    private ToolProvider() {
    }

    static <T> T trace(Level level, Object object) {
        try {
            if (System.getProperty(propertyName) != null) {
                Object object2;
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                String string = "???";
                String string2 = ToolProvider.class.getName();
                if (stackTraceElementArray.length > 2) {
                    object2 = stackTraceElementArray[2];
                    string = String.format((Locale)null, "%s(%s:%s)", ((StackTraceElement)object2).getMethodName(), ((StackTraceElement)object2).getFileName(), ((StackTraceElement)object2).getLineNumber());
                    string2 = ((StackTraceElement)object2).getClassName();
                }
                object2 = Logger.getLogger(loggerName);
                if (object instanceof Throwable) {
                    ((Logger)object2).logp(level, string2, string, object.getClass().getName(), (Throwable)object);
                } else {
                    ((Logger)object2).logp(level, string2, string, String.valueOf(object));
                }
            }
        }
        catch (SecurityException securityException) {
            System.err.format((Locale)null, "%s: %s; %s%n", ToolProvider.class.getName(), object, securityException.getLocalizedMessage());
        }
        return null;
    }

    public static JavaCompiler getSystemJavaCompiler() {
        if (Lazy.compilerClass == null) {
            return (JavaCompiler)ToolProvider.trace(Level.WARNING, "Lazy.compilerClass == null");
        }
        try {
            return Lazy.compilerClass.newInstance();
        }
        catch (Throwable throwable) {
            return (JavaCompiler)ToolProvider.trace(Level.WARNING, throwable);
        }
    }

    public static ClassLoader getSystemToolClassLoader() {
        if (Lazy.compilerClass == null) {
            return (ClassLoader)ToolProvider.trace(Level.WARNING, "Lazy.compilerClass == null");
        }
        return Lazy.compilerClass.getClassLoader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Lazy {
        private static final String defaultJavaCompilerName = "edu.rice.cs.mint.comp.com.sun.tools.javac.api.JavacTool";
        private static final String[] defaultToolsLocation = new String[]{"lib", "tools.jar"};
        static final Class<? extends JavaCompiler> compilerClass;

        Lazy() {
        }

        private static Class<?> findClass() throws MalformedURLException, ClassNotFoundException {
            try {
                return Lazy.enableAsserts(Class.forName(defaultJavaCompilerName, false, null));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ToolProvider.trace(Level.FINE, classNotFoundException);
                File file = new File(System.getProperty("java.home"));
                if (file.getName().equalsIgnoreCase("jre")) {
                    file = file.getParentFile();
                }
                for (String string : defaultToolsLocation) {
                    file = new File(file, string);
                }
                Object[] objectArray = new URL[]{file.toURI().toURL()};
                ToolProvider.trace(Level.FINE, ((URL)objectArray[0]).toString());
                URLClassLoader uRLClassLoader = URLClassLoader.newInstance((URL[])objectArray);
                uRLClassLoader.setPackageAssertionStatus("edu.rice.cs.mint.comp.com.sun.tools.javac", true);
                return Class.forName(defaultJavaCompilerName, false, uRLClassLoader);
            }
        }

        private static Class<?> enableAsserts(Class<?> clazz) {
            try {
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader != null) {
                    classLoader.setPackageAssertionStatus("edu.rice.cs.mint.comp.com.sun.tools.javac", true);
                } else {
                    ToolProvider.trace(Level.FINE, "loader == null");
                }
            }
            catch (SecurityException securityException) {
                ToolProvider.trace(Level.FINE, securityException);
            }
            return clazz;
        }

        static {
            Class<JavaCompiler> clazz = null;
            try {
                clazz = Lazy.findClass().asSubclass(JavaCompiler.class);
            }
            catch (Throwable throwable) {
                ToolProvider.trace(Level.WARNING, throwable);
            }
            compilerClass = clazz;
        }
    }
}

