/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.runtime;

import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Context;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Options;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Pair;
import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.HashMapClassLoader;
import edu.rice.cs.mint.runtime.InternalError;
import edu.rice.cs.mint.runtime.StringCodeCompiler;
import edu.rice.cs.mint.runtime.mspTree.MSPTree;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSPTreeCode<T>
implements Code<T> {
    private MSPTree mspTree;
    private String retTypeName;
    public boolean isStat;
    private static final boolean _mintverbose = System.getenv("mintverbose") != null;
    protected static int gensym_counter = 1;
    private static int var_gensym_counter = 1;
    protected static Context context = null;

    protected static synchronized String uniqueCodeName() {
        return "$$Code" + gensym_counter++ + "$$";
    }

    public static String varGenSym(String string) {
        return string + "$$$" + var_gensym_counter++;
    }

    public MSPTreeCode(MSPTree mSPTree, String string, boolean bl) {
        this.mspTree = mSPTree;
        this.retTypeName = string;
        this.isStat = bl;
    }

    public static <U> MSPTree escape(Code<U> code) {
        try {
            return ((MSPTreeCode)code).mspTree;
        }
        catch (ClassCastException classCastException) {
            System.err.println("Internal error in MSPTreeCode: argument in escape is of type " + code.getClass().toString());
            classCastException.printStackTrace(System.err);
            System.exit(1);
            return null;
        }
    }

    ClassInfo generateClass(String string) {
        return this.generateClass(string, MSPTreeCode.initContext());
    }

    ClassInfo generateClass(String string, Context context) {
        int n;
        Pair<String, ArrayList<Pair<Object, String>>> pair = this.mspTree.generateCodeCspPair();
        String string2 = (String)pair.fst;
        ClassInfo classInfo = new ClassInfo();
        classInfo.csp_value_type_table = (ArrayList)pair.snd;
        classInfo.csp_table = new Object[classInfo.csp_value_type_table.size()];
        classInfo.csp_type_table = new String[classInfo.csp_value_type_table.size()];
        for (int i = 0; i < classInfo.csp_value_type_table.size(); ++i) {
            classInfo.csp_table[i] = classInfo.csp_value_type_table.get((int)i).fst;
            classInfo.csp_type_table[i] = (String)classInfo.csp_value_type_table.get((int)i).snd;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("public class ");
        stringBuilder.append(string);
        stringBuilder.append(" implements edu.rice.cs.mint.runtime.Code<");
        String string3 = this.retTypeName;
        stringBuilder.append(this.retTypeName);
        stringBuilder.append("> { \n");
        for (n = 0; n < classInfo.csp_type_table.length; ++n) {
            stringBuilder.append("private final ").append(classInfo.csp_type_table[n]).append(" ").append("$csp_value_");
            stringBuilder.append(n).append(";\n");
        }
        stringBuilder.append("public " + string);
        stringBuilder.append("(Object[] csp_table) {\n");
        for (n = 0; n < classInfo.csp_type_table.length; ++n) {
            stringBuilder.append("this.$csp_value_").append(n).append(" = ((");
            stringBuilder.append(classInfo.csp_type_table[n]).append(")").append("csp_table[");
            stringBuilder.append(n).append("]);\n");
        }
        stringBuilder.append("}\n");
        stringBuilder.append("public " + string3 + " run() {\n");
        stringBuilder.append("try {\n");
        if (this.isStat) {
            stringBuilder.append("if (true) {\n");
            stringBuilder.append(string2);
            stringBuilder.append("\n}\nreturn null;\n");
        } else {
            stringBuilder.append("return\n");
            stringBuilder.append(string2);
            stringBuilder.append(";\n");
        }
        stringBuilder.append("}\n");
        stringBuilder.append("catch(RuntimeException $rte) { throw $rte; }\n");
        stringBuilder.append("catch(Error $e) { throw $e; }\n");
        stringBuilder.append("catch(Throwable $t) { throw new edu.rice.cs.mint.runtime.CheckedExceptionInCode($t); }\n");
        stringBuilder.append("}\n");
        stringBuilder.append("}");
        classInfo.text = stringBuilder.toString();
        StringCodeCompiler stringCodeCompiler = (StringCodeCompiler)StringCodeCompiler.instance(context);
        Options options = Options.instance(context);
        options.put("-classpath", HashMapClassLoader.instance().getClassPathPropertyValue());
        classInfo.bytes_hash = stringCodeCompiler.compileStringToBytes(string, stringBuilder.toString());
        return classInfo;
    }

    public T run(Context context) {
        String string = MSPTreeCode.uniqueCodeName();
        ClassInfo classInfo = this.generateClass(string);
        String string2 = classInfo.text;
        if (_mintverbose) {
            System.out.println(string2.toString());
        }
        StringCodeCompiler stringCodeCompiler = (StringCodeCompiler)StringCodeCompiler.instance(context);
        Options options = Options.instance(context);
        options.put("-classpath", HashMapClassLoader.instance().getClassPathPropertyValue());
        HashMap<String, byte[]> hashMap = classInfo.bytes_hash;
        try {
            Code<?> code = MSPTreeCode.loadClassAndCreateInstance(string, hashMap, classInfo.csp_table);
            return (T)code.run();
        }
        catch (InternalError internalError) {
            internalError.printStackTrace(System.err);
            System.exit(1);
            return null;
        }
    }

    static Code<?> loadClassAndCreateInstance(String string, HashMap<String, byte[]> hashMap, Object[] objectArray) {
        HashMapClassLoader hashMapClassLoader = HashMapClassLoader.instance(hashMap);
        try {
            Class<?> clazz = hashMapClassLoader.loadClass(string);
            Constructor<?> constructor = clazz.getConstructor(Object[].class);
            return (Code)constructor.newInstance(new Object[]{objectArray});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError("Internal error in MSPTreeCode: class " + string + " not found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError("Internal error in MSPTreeCode: class " + string + " could not be instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError("Internal error in MSPTreeCode: illegal access for constructor in class " + string, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError("Internal error in MSPTreeCode: constructor for " + string + " does not exist", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError("Internal error in MSPTreeCode: unexpected exception in constructor for class " + string, invocationTargetException);
        }
    }

    protected static synchronized Context initContext() {
        if (context == null) {
            context = new Context();
            StringCodeCompiler.preRegister(context);
        }
        return context;
    }

    @Override
    public T run() {
        return this.run(MSPTreeCode.initContext());
    }

    public String toString() {
        Pair<String, ArrayList<Pair<Object, String>>> pair = this.mspTree.generateCodeCspPair();
        return "<| " + (String)pair.fst + " |>";
    }

    public static class ClassInfo {
        public String text;
        public ArrayList<Pair<Object, String>> csp_value_type_table;
        public Object[] csp_table;
        public String[] csp_type_table;
        public HashMap<String, byte[]> bytes_hash;
    }
}

