package edu.rice.cs.mint.util;

import java.util.*;

/**
 * Range functions to write forall loops instead of for loops.
 */
public class Range {
    /** Return an Iterable for use with a forall loop that starts at the first value and ends before reaching
      * the second value.
      * @param firstInclusive first value of the Iterable
      * @param lastExclusive value that is out of range on the high end
      * @return Iterable for the range [firstInclusive, lastExclusive)
      */
    public static separable Iterable<Integer> range(final int firstInclusive, final int lastExclusive) {
        final boolean increment = (firstInclusive<lastExclusive); 
        final int step = increment?1:-1;
        return new Iterable<Integer>() {
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>() {
                    int current = firstInclusive;
                    public boolean hasNext() {
                        return (increment)?(current<lastExclusive):(current>lastExclusive);
                    }
                    public Integer next() {
                        if (!hasNext()) throw new NoSuchElementException();
                        int temp = current;
                        current += step;
                        return temp;
                    }
                    public void remove() { throw new UnsupportedOperationException(); }
                };
            }
        };
    }
    
    /** Return an Iterable for use with a forall loop that starts at the first value and ends before reaching
      * the second value.
      * @param firstInclusive first value of the Iterable
      * @param lastExclusive value that is out of range on the high end
      * @return Iterable for the range [firstInclusive, lastExclusive)
      */
    public static separable Iterable<Long> range(final long firstInclusive, final long lastExclusive) {
        final boolean increment = (firstInclusive<lastExclusive); 
        final int step = increment?1:-1;
        return new Iterable<Long>() {
            public Iterator<Long> iterator() {
                return new Iterator<Long>() {
                    long current = firstInclusive;
                    public boolean hasNext() {
                        return (increment)?(current<lastExclusive):(current>lastExclusive);
                    }
                    public Long next() {
                        if (!hasNext()) throw new NoSuchElementException();
                        long temp = current;
                        current += step;
                        return temp;
                    }
                    public void remove() { throw new UnsupportedOperationException(); }
                };
            }
        };
    }
    
    /** Return an Iterable for use with a forall loop that starts at the first value and ends before reaching
      * the second value.
      * @param firstInclusive first value of the Iterable
      * @param lastExclusive value that is out of range on the high end
      * @return Iterable for the range [firstInclusive, lastExclusive)
      */
    public static separable Iterable<Byte> range(final byte firstInclusive, final byte lastExclusive) {
        final boolean increment = (firstInclusive<lastExclusive); 
        final int step = increment?1:-1;
        return new Iterable<Byte>() {
            public Iterator<Byte> iterator() {
                return new Iterator<Byte>() {
                    byte current = firstInclusive;
                    public boolean hasNext() {
                        return (increment)?(current<lastExclusive):(current>lastExclusive);
                    }
                    public Byte next() {
                        if (!hasNext()) throw new NoSuchElementException();
                        byte temp = current;
                        current += step;
                        return temp;
                    }
                    public void remove() { throw new UnsupportedOperationException(); }
                };
            }
        };
    }
    
    /** Return an Iterable for use with a forall loop that starts at the first value and ends before reaching
      * the second value.
      * @param firstInclusive first value of the Iterable
      * @param lastExclusive value that is out of range on the high end
      * @return Iterable for the range [firstInclusive, lastExclusive)
      */
    public static separable Iterable<Character> range(final char firstInclusive, final char lastExclusive) {
        final boolean increment = (firstInclusive<lastExclusive); 
        final int step = increment?1:-1;
        return new Iterable<Character>() {
            public Iterator<Character> iterator() {
                return new Iterator<Character>() {
                    char current = firstInclusive;
                    public boolean hasNext() {
                        return (increment)?(current<lastExclusive):(current>lastExclusive);
                    }
                    public Character next() {
                        if (!hasNext()) throw new NoSuchElementException();
                        char temp = current;
                        current += step;
                        return temp;
                    }
                    public void remove() { throw new UnsupportedOperationException(); }
                };
            }
        };
    }

    /** Return an Iterable for use with a forall loop that starts at the first value and ends before reaching
      * the second value.
      * @param firstInclusive first value of the Iterable
      * @param lastExclusive value that is out of range on the high end
      * @return Iterable for the range [firstInclusive, lastExclusive)
      */
    public static separable Iterable<Short> range(final short firstInclusive, final short lastExclusive) {
        final boolean increment = (firstInclusive<lastExclusive); 
        final int step = increment?1:-1;
        return new Iterable<Short>() {
            public Iterator<Short> iterator() {
                return new Iterator<Short>() {
                    short current = firstInclusive;
                    public boolean hasNext() {
                        return (increment)?(current<lastExclusive):(current>lastExclusive);
                    }
                    public Short next() {
                        if (!hasNext()) throw new NoSuchElementException();
                        short temp = current;
                        current += step;
                        return temp;
                    }
                    public void remove() { throw new UnsupportedOperationException(); }
                };
            }
        };
    }
    
    public static void main(String[] args) {
        for(final int i: range(0,10)) System.out.print(i+" ");
        System.out.println();
        for(final int i: range(10,0)) System.out.print(i+" ");
        System.out.println();
    }
}
