package hj.lang;

import hj.array.RegionRectangular;

public abstract class ArrayView  {
 
 // These are dependent-type parameter
 /*parameter*/ public final /*nat*/int rank;
 /*parameter*/ public final /*nat*/int base;
 public static final String propertyNames$ = " rank base offset ";

 
 /**
  * The offset from where to start index computation on the base array;
  */
 public final int offset;
 public final RegionRectangular region;
 
 public separable ArrayView(int offset, RegionRectangular rectRegion) {
  this.offset = offset;
  
  // Throws an exception if user didn't provide a RectangularRegion
  this.region = (RegionRectangular) rectRegion;
  
  // initialize dep-type
  this.rank = rectRegion.rank;
  this.base = rectRegion.base;
  if (this.offset < 0) {
   throw new RuntimeException("ArrayView offset must be positive");
  }
 }
 
 public final separable int getDimensionSize(int dimension) {
  return region.getDimensionSize(dimension);
 }
 
 public separable int getRowOffset(int i) {
  //compute new offset
  return region.ordinal(i, region.low_J);
 }

 public separable int getRowOffset(int i, int j) {
  //compute new offset
  return region.ordinal(i, j, region.low_K);
 }
}
