/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.code;

import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symbol;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Name;
import java.util.Iterator;

public class Scope {
    private int shared;
    public Scope next;
    public Symbol owner;
    public Entry[] table;
    int hashMask;
    public Entry elems;
    public int nelems = 0;
    public Symbol.Level level;
    private static final Entry sentinel = new Entry(null, null, null, null);
    private static final int INITIAL_SIZE = 16;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0], new Symbol.Level(0));

    public int getLevel() {
        return this.level.getLevel();
    }

    Scope(Scope scope, Symbol symbol, Entry[] entryArray, Symbol.Level level) {
        this.next = scope;
        assert (emptyScope == null || symbol != null);
        this.owner = symbol;
        this.table = entryArray;
        this.hashMask = entryArray.length - 1;
        this.elems = null;
        this.nelems = 0;
        this.shared = 0;
        this.level = level;
    }

    public Scope(Symbol symbol, Symbol.Level level) {
        this(null, symbol, new Entry[16], level);
        for (int i = 0; i < 16; ++i) {
            this.table[i] = sentinel;
        }
    }

    public Scope(Symbol symbol, int n) {
        this(symbol, new Symbol.Level(n));
    }

    public Scope(Symbol symbol) {
        this(symbol, new Symbol.Level(symbol.level));
    }

    public Scope dup() {
        Scope scope = new Scope(this, this.owner, this.table, this.level.dup());
        ++this.shared;
        return scope;
    }

    public Scope dup(Symbol symbol) {
        Scope scope = new Scope(this, symbol, this.table, this.level.dup());
        ++this.shared;
        return scope;
    }

    public Scope dupUnshared() {
        return new Scope(this, this.owner, (Entry[])this.table.clone(), this.level.dup());
    }

    public Scope leave() {
        assert (this.shared == 0);
        if (this.table != this.next.table) {
            return this.next;
        }
        while (this.elems != null) {
            int n = this.elems.sym.name.hashCode() & this.hashMask;
            Entry entry = this.table[n];
            assert (entry == this.elems) : this.elems.sym;
            this.table[n] = this.elems.shadowed;
            this.elems = this.elems.sibling;
        }
        assert (this.next.shared > 0);
        --this.next.shared;
        return this.next;
    }

    private void dble() {
        int n;
        assert (this.shared == 0);
        Entry[] entryArray = this.table;
        Entry[] entryArray2 = new Entry[entryArray.length * 2];
        Scope scope = this;
        while (scope != null) {
            if (scope.table == entryArray) {
                assert (scope == this || scope.shared != 0);
                scope.table = entryArray2;
                scope.hashMask = entryArray2.length - 1;
            }
            scope = scope.next;
        }
        for (n = 0; n < entryArray2.length; ++n) {
            entryArray2[n] = sentinel;
        }
        for (n = 0; n < entryArray.length; ++n) {
            this.copy(entryArray[n]);
        }
    }

    private void copy(Entry entry) {
        if (entry.sym != null) {
            this.copy(entry.shadowed);
            int n = entry.sym.name.hashCode() & this.hashMask;
            entry.shadowed = this.table[n];
            this.table[n] = entry;
        }
    }

    public void enter(Symbol symbol) {
        assert (this.shared == 0);
        this.enter(symbol, this);
    }

    public void enter(Symbol symbol, Scope scope) {
        this.enter(symbol, scope, scope);
    }

    public void enter(Symbol symbol, Scope scope, Scope scope2) {
        Entry entry;
        assert (this.shared == 0);
        int n = symbol.name.hashCode() & this.hashMask;
        this.table[n] = entry = this.makeEntry(symbol, this.table[n], this.elems, scope, scope2);
        this.elems = entry;
        ++this.nelems;
        symbol.addParentLevel(this.level);
    }

    Entry makeEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope, Scope scope2) {
        return new Entry(symbol, entry, entry2, scope);
    }

    public void remove(Symbol symbol) {
        assert (this.shared == 0);
        symbol.removeParentLevel(this.level);
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this && entry.sym != symbol) {
            entry = entry.next();
        }
        if (entry.scope == null) {
            return;
        }
        Entry entry2 = this.table[symbol.name.hashCode() & this.hashMask];
        if (entry2 == entry) {
            this.table[symbol.name.hashCode() & this.hashMask] = entry.shadowed;
        } else {
            while (true) {
                if (entry2.shadowed == entry) {
                    entry2.shadowed = entry.shadowed;
                    break;
                }
                entry2 = entry2.shadowed;
            }
        }
        entry2 = this.elems;
        if (entry2 == entry) {
            this.elems = entry.sibling;
        } else {
            while (true) {
                if (entry2.sibling == entry) {
                    entry2.sibling = entry.sibling;
                    break;
                }
                entry2 = entry2.sibling;
            }
        }
    }

    public void enterIfAbsent(Symbol symbol) {
        assert (this.shared == 0);
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this && entry.sym.kind != symbol.kind) {
            entry = entry.next();
        }
        if (entry.scope != this) {
            this.enter(symbol);
        }
    }

    public boolean includes(Symbol symbol) {
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this) {
            if (entry.sym == symbol) {
                return true;
            }
            entry = entry.next();
        }
        return false;
    }

    public Entry lookup(Name name) {
        Entry entry = this.table[name.hashCode() & this.hashMask];
        while (entry.scope != null && entry.sym.name != name) {
            entry = entry.shadowed;
        }
        return entry;
    }

    public Iterable<Symbol> getElements() {
        return new Iterable<Symbol>(){

            @Override
            public Iterator<Symbol> iterator() {
                return new Iterator<Symbol>(){
                    private Scope currScope;
                    private Entry currEntry;
                    {
                        this.currScope = Scope.this;
                        this.currEntry = Scope.this.elems;
                        this.update();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currEntry != null;
                    }

                    @Override
                    public Symbol next() {
                        Symbol symbol = this.currEntry == null ? null : this.currEntry.sym;
                        this.currEntry = this.currEntry.sibling;
                        this.update();
                        return symbol;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void update() {
                        while (this.currEntry == null && this.currScope.next != null) {
                            this.currScope = this.currScope.next;
                            this.currEntry = this.currScope.elems;
                        }
                    }
                };
            }
        };
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Scope[");
        Scope scope = this;
        while (scope != null) {
            if (scope != this) {
                stringBuilder.append(" | ");
            }
            Entry entry = scope.elems;
            while (entry != null) {
                if (entry != scope.elems) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.sym);
                entry = entry.sibling;
            }
            scope = scope.next;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class ErrorScope
    extends Scope {
        ErrorScope(Scope scope, Symbol symbol, Entry[] entryArray) {
            super(scope, symbol, entryArray, new Symbol.Level(symbol.level));
        }

        public ErrorScope(Symbol symbol) {
            super(symbol);
        }

        @Override
        public Scope dup() {
            return new ErrorScope(this, this.owner, this.table);
        }

        @Override
        public Scope dupUnshared() {
            return new ErrorScope(this, this.owner, (Entry[])this.table.clone());
        }

        @Override
        public Entry lookup(Name name) {
            Entry entry = super.lookup(name);
            if (entry.scope == null) {
                return new Entry(this.owner, null, null, null);
            }
            return entry;
        }
    }

    public static class DelegatedScope
    extends Scope {
        Scope delegatee;
        public static final Entry[] emptyTable = new Entry[0];

        public DelegatedScope(Scope scope) {
            super(scope, scope.owner, emptyTable, scope.level.dup());
            this.delegatee = scope;
        }

        @Override
        public Scope dup() {
            return new DelegatedScope(this.next);
        }

        @Override
        public Scope dupUnshared() {
            return new DelegatedScope(this.next);
        }

        @Override
        public Scope leave() {
            return this.next;
        }

        @Override
        public void enter(Symbol symbol) {
        }

        @Override
        public void enter(Symbol symbol, Scope scope) {
        }

        @Override
        public void remove(Symbol symbol) {
            throw new AssertionError(symbol);
        }

        @Override
        public Entry lookup(Name name) {
            return this.delegatee.lookup(name);
        }
    }

    public static class ImportScope
    extends Scope {
        public ImportScope(Symbol symbol) {
            super(symbol);
        }

        @Override
        Entry makeEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope, Scope scope2) {
            return new ImportEntry(symbol, entry, entry2, scope, scope2);
        }

        @Override
        public Entry lookup(Name name) {
            Entry entry = this.table[name.hashCode() & this.hashMask];
            while (entry.scope != null && (entry.sym.name != name || entry.sym.owner != entry.scope.owner)) {
                entry = entry.shadowed;
            }
            return entry;
        }

        static class ImportEntry
        extends Entry {
            private Scope origin;

            ImportEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope, Scope scope2) {
                super(symbol, entry, entry2, scope);
                this.origin = scope2;
            }

            @Override
            public Entry next() {
                Entry entry = ((Entry)this).shadowed;
                while (entry.scope != null && (entry.sym.name != this.sym.name || entry.sym.owner != entry.scope.owner)) {
                    entry = entry.shadowed;
                }
                return entry;
            }

            @Override
            public Scope getOrigin() {
                return this.origin;
            }
        }
    }

    public static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
            this.sym = symbol;
            this.shadowed = entry;
            this.sibling = entry2;
            this.scope = scope;
        }

        public Entry next() {
            Entry entry = this.shadowed;
            while (entry.scope != null && entry.sym.name != this.sym.name) {
                entry = entry.shadowed;
            }
            return entry;
        }

        public Scope getOrigin() {
            return this.scope;
        }
    }
}

