/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.model;

import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Attribute;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Scope;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symbol;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Type;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.List;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Name;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Pair;
import edu.rice.cs.mint.comp.javax.lang.model.type.MirroredTypeException;
import edu.rice.cs.mint.comp.javax.lang.model.type.MirroredTypesException;
import edu.rice.cs.mint.comp.javax.lang.model.type.TypeMirror;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

public class AnnotationProxyMaker {
    private final Attribute.Compound anno;
    private final Class<? extends Annotation> annoType;

    private AnnotationProxyMaker(Attribute.Compound compound, Class<? extends Annotation> clazz) {
        this.anno = compound;
        this.annoType = clazz;
    }

    public static <A extends Annotation> A generateAnnotation(Attribute.Compound compound, Class<A> clazz) {
        AnnotationProxyMaker annotationProxyMaker = new AnnotationProxyMaker(compound, clazz);
        return (A)((Annotation)clazz.cast(annotationProxyMaker.generateAnnotation()));
    }

    private Annotation generateAnnotation() {
        return AnnotationParser.annotationForMap(this.annoType, this.getAllReflectedValues());
    }

    private Map<String, Object> getAllReflectedValues() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<Symbol.MethodSymbol, Attribute> entry : this.getAllValues().entrySet()) {
            Symbol.MethodSymbol methodSymbol = entry.getKey();
            Object object = this.generateValue(methodSymbol, entry.getValue());
            if (object == null) continue;
            linkedHashMap.put(methodSymbol.name.toString(), object);
        }
        return linkedHashMap;
    }

    private Map<Symbol.MethodSymbol, Attribute> getAllValues() {
        LinkedHashMap<Symbol.MethodSymbol, Attribute> linkedHashMap = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.anno.type.tsym;
        Object object = classSymbol.members().elems;
        while (object != null) {
            Symbol.MethodSymbol object2;
            Attribute attribute;
            if (((Scope.Entry)object).sym.kind == 16 && (attribute = (object2 = (Symbol.MethodSymbol)((Scope.Entry)object).sym).getDefaultValue()) != null) {
                linkedHashMap.put(object2, attribute);
            }
            object = ((Scope.Entry)object).sibling;
        }
        for (Pair pair : this.anno.values) {
            linkedHashMap.put((Symbol.MethodSymbol)pair.fst, (Attribute)pair.snd);
        }
        return linkedHashMap;
    }

    private Object generateValue(Symbol.MethodSymbol methodSymbol, Attribute attribute) {
        ValueVisitor valueVisitor = new ValueVisitor(methodSymbol);
        return valueVisitor.getValue(attribute);
    }

    private static class MirroredTypesExceptionProxy
    extends ExceptionProxy {
        static final long serialVersionUID = 269L;
        private final transient List<TypeMirror> types;
        private final String typeStrings;

        MirroredTypesExceptionProxy(List<TypeMirror> list) {
            this.types = list;
            this.typeStrings = list.toString();
        }

        public String toString() {
            return this.typeStrings;
        }

        public int hashCode() {
            return (this.types != null ? this.types : this.typeStrings).hashCode();
        }

        public boolean equals(Object object) {
            return this.types != null && object instanceof MirroredTypesExceptionProxy && this.types.equals(((MirroredTypesExceptionProxy)object).types);
        }

        @Override
        protected RuntimeException generateException() {
            return new MirroredTypesException(this.types);
        }
    }

    private static class MirroredTypeExceptionProxy
    extends ExceptionProxy {
        static final long serialVersionUID = 269L;
        private final transient TypeMirror type;
        private final String typeString;

        MirroredTypeExceptionProxy(TypeMirror typeMirror) {
            this.type = typeMirror;
            this.typeString = ((Object)typeMirror).toString();
        }

        public String toString() {
            return this.typeString;
        }

        public int hashCode() {
            return (this.type != null ? this.type : this.typeString).hashCode();
        }

        public boolean equals(Object object) {
            return this.type != null && object instanceof MirroredTypeExceptionProxy && ((Object)this.type).equals(((MirroredTypeExceptionProxy)object).type);
        }

        @Override
        protected RuntimeException generateException() {
            return new MirroredTypeException(this.type);
        }
    }

    private class ValueVisitor
    implements Attribute.Visitor {
        private Symbol.MethodSymbol meth;
        private Class<?> returnClass;
        private Object value;

        ValueVisitor(Symbol.MethodSymbol methodSymbol) {
            this.meth = methodSymbol;
        }

        Object getValue(Attribute attribute) {
            Method method;
            try {
                method = AnnotationProxyMaker.this.annoType.getMethod(this.meth.name.toString(), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            this.returnClass = method.getReturnType();
            attribute.accept(this);
            if (!(this.value instanceof ExceptionProxy) && !AnnotationType.invocationHandlerReturnType(this.returnClass).isInstance(this.value)) {
                this.typeMismatch(method, attribute);
            }
            return this.value;
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            this.value = constant.getValue();
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.value = new MirroredTypeExceptionProxy(clazz.type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitArray(Attribute.Array array) {
            Name name = ((Type.ArrayType)array.type).elemtype.tsym.name;
            if (name == name.table.names.java_lang_Class) {
                List<TypeMirror> list = List.nil();
                for (Attribute attribute : array.values) {
                    Type type = ((Attribute.Class)attribute).type;
                    list.add(type);
                }
                this.value = new MirroredTypesExceptionProxy(list);
            } else {
                int n = array.values.length;
                Class<?> clazz = this.returnClass;
                this.returnClass = this.returnClass.getComponentType();
                try {
                    Object object = Array.newInstance(this.returnClass, n);
                    for (int i = 0; i < n; ++i) {
                        array.values[i].accept(this);
                        if (this.value == null || this.value instanceof ExceptionProxy) {
                            return;
                        }
                        try {
                            Array.set(object, i, this.value);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.value = null;
                            this.returnClass = clazz;
                            return;
                        }
                    }
                    this.value = object;
                }
                finally {
                    this.returnClass = clazz;
                }
            }
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            if (this.returnClass.isEnum()) {
                String string = enum_.value.toString();
                try {
                    this.value = Enum.valueOf(this.returnClass, string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.value = new EnumConstantNotPresentExceptionProxy(this.returnClass, string);
                }
            } else {
                this.value = null;
            }
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            try {
                Class<Annotation> clazz = this.returnClass.asSubclass(Annotation.class);
                this.value = AnnotationProxyMaker.generateAnnotation(compound, clazz);
            }
            catch (ClassCastException classCastException) {
                this.value = null;
            }
        }

        @Override
        public void visitError(Attribute.Error error) {
            this.value = null;
        }

        private void typeMismatch(final Method method, final Attribute attribute) {
            this.value = new ExceptionProxy(){
                static final long serialVersionUID = 269L;

                public String toString() {
                    return "<error>";
                }

                @Override
                protected RuntimeException generateException() {
                    return new AnnotationTypeMismatchException(method, attribute.type.toString());
                }
            };
        }
    }
}

