/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.util;

import edu.rice.cs.mint.comp.com.sun.tools.javac.api.DiagnosticFormatter;
import edu.rice.cs.mint.comp.com.sun.tools.javac.file.JavacFileManager;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.JCTree;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.BasicDiagnosticFormatter;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Context;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.DiagnosticSource;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JavacMessages;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.List;
import edu.rice.cs.mint.comp.javax.tools.Diagnostic;
import edu.rice.cs.mint.comp.javax.tools.JavaFileObject;
import java.util.Locale;
import java.util.Map;

public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticType type;
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final int line;
    private final int column;
    private final String key;
    protected Object[] args;
    private boolean mandatory;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String string, Object ... objectArray) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticType.FRAGMENT, false, null, null, "compiler." + DiagnosticType.FRAGMENT.key + "." + string, objectArray);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> diagnosticFormatter, DiagnosticType diagnosticType, boolean bl, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        int n;
        if (diagnosticSource == null && diagnosticPosition != null && diagnosticPosition.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.defaultFormatter = diagnosticFormatter;
        this.type = diagnosticType;
        this.mandatory = bl;
        this.source = diagnosticSource;
        this.position = diagnosticPosition;
        this.key = string;
        this.args = objectArray;
        int n2 = n = diagnosticPosition == null ? -1 : diagnosticPosition.getPreferredPosition();
        if (n == -1 || diagnosticSource == null) {
            this.column = -1;
            this.line = -1;
        } else {
            this.line = diagnosticSource.getLineNumber(n);
            this.column = diagnosticSource.getColumnNumber(n, true);
        }
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public String getSourceName() {
        JavaFileObject javaFileObject = this.getSource();
        return javaFileObject == null ? null : JavacFileManager.getJavacFileName(javaFileObject);
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    @Override
    public long getLineNumber() {
        return this.line;
    }

    @Override
    public long getColumnNumber() {
        return this.column;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.type);
    }

    public String getPrefix(DiagnosticType diagnosticType) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.mandatory ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.key;
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic jCDiagnostic, List<JCDiagnostic> list) {
            super(jCDiagnostic.defaultFormatter, jCDiagnostic.getType(), jCDiagnostic.isMandatory(), jCDiagnostic.getDiagnosticSource(), jCDiagnostic.position, jCDiagnostic.getCode(), jCDiagnostic.getArgs());
            this.subdiagnostics = list;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int n) {
            this.pos = n;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(Map<JCTree, Integer> map) {
            return this.pos;
        }
    }

    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(Map<JCTree, Integer> var1);
    }

    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String string2) {
            this.key = string2;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;

        public static Factory instance(Context context) {
            Factory factory = context.get(diagnosticFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
        }

        public Factory(JavacMessages javacMessages, String string) {
            this.prefix = string;
            this.formatter = new BasicDiagnosticFormatter(javacMessages);
        }

        public JCDiagnostic error(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.formatter, DiagnosticType.ERROR, true, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.ERROR, string), objectArray);
        }

        public JCDiagnostic mandatoryWarning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.formatter, DiagnosticType.WARNING, true, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.WARNING, string), objectArray);
        }

        public JCDiagnostic warning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.formatter, DiagnosticType.WARNING, false, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.WARNING, string), objectArray);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource diagnosticSource, String string, Object ... objectArray) {
            return new JCDiagnostic(this.formatter, DiagnosticType.NOTE, true, diagnosticSource, null, this.qualify(DiagnosticType.NOTE, string), objectArray);
        }

        public JCDiagnostic note(String string, Object ... objectArray) {
            return this.note(null, null, string, objectArray);
        }

        public JCDiagnostic note(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.formatter, DiagnosticType.NOTE, false, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.NOTE, string), objectArray);
        }

        public JCDiagnostic fragment(String string, Object ... objectArray) {
            return new JCDiagnostic(this.formatter, DiagnosticType.FRAGMENT, false, null, null, this.qualify(DiagnosticType.FRAGMENT, string), objectArray);
        }

        protected String qualify(DiagnosticType diagnosticType, String string) {
            return this.prefix + "." + diagnosticType.key + "." + string;
        }
    }
}

