/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.runtime;

import edu.rice.cs.mint.runtime.HashMapClassLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Mint {
    public static void main(String[] stringArray) {
        Mint.execute("edu.rice.cs.drjava.interactions.class.path", stringArray);
    }

    public static void execute(String string, String ... stringArray) {
        if (stringArray.length == 0) {
            System.out.println(Mint.class.getName() + " - Mint program launcher");
            System.out.println("Syntax: java " + Mint.class.getName() + " <class> [arguments]");
            System.exit(1);
        }
        String string2 = stringArray[0];
        try {
            HashMapClassLoader hashMapClassLoader = null;
            hashMapClassLoader = string != null ? HashMapClassLoader.instance(string) : HashMapClassLoader.instance();
            Class<?> clazz = hashMapClassLoader.loadClass(string2);
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            Class[] classArray = new Class[]{stringArray2.getClass()};
            Method method = clazz.getMethod("main", classArray);
            method.invoke(null, new Object[]{stringArray2});
        }
        catch (ClassNotFoundException classNotFoundException) {
            Mint.handleReflectionException(classNotFoundException, string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Mint.handleReflectionException(noSuchMethodException, string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            Mint.handleReflectionException(illegalAccessException, string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Mint.handleReflectionException(invocationTargetException, string2);
        }
        catch (LinkageError linkageError) {
            Mint.handleReflectionException(linkageError, string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public static void handleReflectionException(Throwable throwable, String string) {
        System.err.print("Exception in thread \"" + Thread.currentThread().getName() + "\" ");
        if (throwable.getCause() != null) {
            int n;
            StackTraceElement[] stackTraceElementArray = throwable.getCause().getStackTrace();
            for (n = stackTraceElementArray.length - 1; n > 0 && !stackTraceElementArray[n].getClassName().equals(string); --n) {
            }
            StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n + 1];
            System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray2, 0, n + 1);
            throwable.getCause().setStackTrace(stackTraceElementArray2);
            throwable.getCause().printStackTrace(System.err);
        } else {
            throwable.printStackTrace(System.err);
        }
    }
}

