/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.classfile;

import edu.rice.cs.mint.comp.com.sun.tools.classfile.AccessFlags;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Annotation;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.AnnotationDefault_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Attributes;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.CharacterRangeTable_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ClassFile;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Code_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.CompilationID_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ConstantPool;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ConstantPoolException;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ConstantValue_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.DefaultAttribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Deprecated_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Descriptor;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.EnclosingMethod_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Exceptions_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Field;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.InnerClasses_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.LineNumberTable_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.LocalVariableTable_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.LocalVariableTypeTable_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Method;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ModuleExportTable_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ModuleMemberTable_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Module_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.RuntimeInvisibleAnnotations_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.RuntimeInvisibleParameterAnnotations_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.RuntimeVisibleAnnotations_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.RuntimeVisibleParameterAnnotations_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Signature_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.SourceDebugExtension_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.SourceFile_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.SourceID_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.StackMapTable_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.StackMap_attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Synthetic_attribute;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ClassWriter {
    protected ClassFile classFile;
    protected ClassOutputStream out;
    protected AttributeWriter attributeWriter = new AttributeWriter();
    protected ConstantPoolWriter constantPoolWriter = new ConstantPoolWriter();

    public ClassWriter() {
        this.out = new ClassOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ClassFile classFile, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.write(classFile, fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void write(ClassFile classFile, OutputStream outputStream) throws IOException {
        this.classFile = classFile;
        this.out.reset();
        this.write();
        this.out.writeTo(outputStream);
    }

    protected void write() throws IOException {
        this.writeHeader();
        this.writeConstantPool();
        this.writeAccessFlags(this.classFile.access_flags);
        this.writeClassInfo();
        this.writeFields();
        this.writeMethods();
        this.writeAttributes(this.classFile.attributes);
    }

    protected void writeHeader() {
        this.out.writeInt(this.classFile.magic);
        this.out.writeShort(this.classFile.minor_version);
        this.out.writeShort(this.classFile.major_version);
    }

    protected void writeAccessFlags(AccessFlags accessFlags) {
        this.out.writeShort(accessFlags.flags);
    }

    protected void writeAttributes(Attributes attributes) {
        int n = attributes.size();
        this.out.writeShort(n);
        for (Attribute attribute : attributes) {
            this.attributeWriter.write(attribute, this.out);
        }
    }

    protected void writeClassInfo() {
        this.out.writeShort(this.classFile.this_class);
        this.out.writeShort(this.classFile.super_class);
        int[] nArray = this.classFile.interfaces;
        this.out.writeShort(nArray.length);
        for (int n : nArray) {
            this.out.writeShort(n);
        }
    }

    protected void writeDescriptor(Descriptor descriptor) {
        this.out.writeShort(descriptor.index);
    }

    protected void writeConstantPool() {
        ConstantPool constantPool = this.classFile.constant_pool;
        int n = constantPool.size();
        this.out.writeShort(n);
        try {
            for (int i = 1; i < n; i += this.constantPoolWriter.write(constantPool.get(i), this.out)) {
            }
        }
        catch (ConstantPoolException constantPoolException) {
            throw new Error(constantPoolException);
        }
    }

    protected void writeFields() throws IOException {
        Field[] fieldArray = this.classFile.fields;
        this.out.writeShort(fieldArray.length);
        for (Field field : fieldArray) {
            this.writeField(field);
        }
    }

    protected void writeField(Field field) throws IOException {
        this.writeAccessFlags(field.access_flags);
        this.out.writeShort(field.name_index);
        this.writeDescriptor(field.descriptor);
        this.writeAttributes(field.attributes);
    }

    protected void writeMethods() throws IOException {
        Method[] methodArray = this.classFile.methods;
        this.out.writeShort(methodArray.length);
        for (Method method : methodArray) {
            this.writeMethod(method);
        }
    }

    protected void writeMethod(Method method) throws IOException {
        this.writeAccessFlags(method.access_flags);
        this.out.writeShort(method.name_index);
        this.writeDescriptor(method.descriptor);
        this.writeAttributes(method.attributes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AnnotationWriter
    implements Annotation.element_value.Visitor<Void, ClassOutputStream> {
        protected AnnotationWriter() {
        }

        public void write(Annotation[] annotationArray, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(annotationArray.length);
            for (Annotation annotation : annotationArray) {
                this.write(annotation, classOutputStream);
            }
        }

        public void write(Annotation annotation, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(annotation.type_index);
            classOutputStream.writeShort(annotation.element_value_pairs.length);
            for (Annotation.element_value_pair element_value_pair2 : annotation.element_value_pairs) {
                this.write(element_value_pair2, classOutputStream);
            }
        }

        public void write(Annotation.element_value_pair element_value_pair2, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(element_value_pair2.element_name_index);
            this.write(element_value_pair2.value, classOutputStream);
        }

        public void write(Annotation.element_value element_value2, ClassOutputStream classOutputStream) {
            classOutputStream.writeByte(element_value2.tag);
            element_value2.accept(this, classOutputStream);
        }

        @Override
        public Void visitPrimitive(Annotation.Primitive_element_value primitive_element_value, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(primitive_element_value.const_value_index);
            return null;
        }

        @Override
        public Void visitEnum(Annotation.Enum_element_value enum_element_value, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(enum_element_value.type_name_index);
            classOutputStream.writeShort(enum_element_value.const_name_index);
            return null;
        }

        @Override
        public Void visitClass(Annotation.Class_element_value class_element_value, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(class_element_value.class_info_index);
            return null;
        }

        @Override
        public Void visitAnnotation(Annotation.Annotation_element_value annotation_element_value, ClassOutputStream classOutputStream) {
            this.write(annotation_element_value.annotation_value, classOutputStream);
            return null;
        }

        @Override
        public Void visitArray(Annotation.Array_element_value array_element_value, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(array_element_value.num_values);
            for (Annotation.element_value element_value2 : array_element_value.values) {
                this.write(element_value2, classOutputStream);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StackMapTableWriter
    implements StackMapTable_attribute.stack_map_frame.Visitor<Void, ClassOutputStream> {
        protected StackMapTableWriter() {
        }

        public void write(StackMapTable_attribute.stack_map_frame stack_map_frame2, ClassOutputStream classOutputStream) {
            classOutputStream.write(stack_map_frame2.frame_type);
            stack_map_frame2.accept(this, classOutputStream);
        }

        @Override
        public Void visit_same_frame(StackMapTable_attribute.same_frame same_frame2, ClassOutputStream classOutputStream) {
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame(StackMapTable_attribute.same_locals_1_stack_item_frame same_locals_1_stack_item_frame2, ClassOutputStream classOutputStream) {
            this.writeVerificationTypeInfo(same_locals_1_stack_item_frame2.stack[0], classOutputStream);
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame_extended(StackMapTable_attribute.same_locals_1_stack_item_frame_extended same_locals_1_stack_item_frame_extended2, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(same_locals_1_stack_item_frame_extended2.offset_delta);
            this.writeVerificationTypeInfo(same_locals_1_stack_item_frame_extended2.stack[0], classOutputStream);
            return null;
        }

        @Override
        public Void visit_chop_frame(StackMapTable_attribute.chop_frame chop_frame2, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(chop_frame2.offset_delta);
            return null;
        }

        @Override
        public Void visit_same_frame_extended(StackMapTable_attribute.same_frame_extended same_frame_extended2, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(same_frame_extended2.offset_delta);
            return null;
        }

        @Override
        public Void visit_append_frame(StackMapTable_attribute.append_frame append_frame2, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(append_frame2.offset_delta);
            for (StackMapTable_attribute.verification_type_info verification_type_info2 : append_frame2.locals) {
                this.writeVerificationTypeInfo(verification_type_info2, classOutputStream);
            }
            return null;
        }

        @Override
        public Void visit_full_frame(StackMapTable_attribute.full_frame full_frame2, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(full_frame2.offset_delta);
            classOutputStream.writeShort(full_frame2.locals.length);
            for (StackMapTable_attribute.verification_type_info verification_type_info2 : full_frame2.locals) {
                this.writeVerificationTypeInfo(verification_type_info2, classOutputStream);
            }
            classOutputStream.writeShort(full_frame2.stack.length);
            for (StackMapTable_attribute.verification_type_info verification_type_info2 : full_frame2.stack) {
                this.writeVerificationTypeInfo(verification_type_info2, classOutputStream);
            }
            return null;
        }

        protected void writeVerificationTypeInfo(StackMapTable_attribute.verification_type_info verification_type_info2, ClassOutputStream classOutputStream) {
            classOutputStream.write(verification_type_info2.tag);
            switch (verification_type_info2.tag) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    StackMapTable_attribute.Object_variable_info object_variable_info = (StackMapTable_attribute.Object_variable_info)verification_type_info2;
                    classOutputStream.writeShort(object_variable_info.cpool_index);
                    break;
                }
                case 8: {
                    StackMapTable_attribute.Uninitialized_variable_info uninitialized_variable_info = (StackMapTable_attribute.Uninitialized_variable_info)verification_type_info2;
                    classOutputStream.writeShort(uninitialized_variable_info.offset);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AttributeWriter
    implements Attribute.Visitor<Void, ClassOutputStream> {
        protected ClassOutputStream sharedOut = new ClassOutputStream();
        protected AnnotationWriter annotationWriter = new AnnotationWriter();
        protected StackMapTableWriter stackMapWriter;

        protected AttributeWriter() {
        }

        public void write(Attributes attributes, ClassOutputStream classOutputStream) {
            int n = attributes.size();
            classOutputStream.writeShort(n);
            for (Attribute attribute : attributes) {
                this.write(attribute, classOutputStream);
            }
        }

        public void write(Attribute attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(attribute.attribute_name_index);
            this.sharedOut.reset();
            attribute.accept(this, this.sharedOut);
            classOutputStream.writeInt(this.sharedOut.size());
            this.sharedOut.writeTo(classOutputStream);
        }

        @Override
        public Void visitDefault(DefaultAttribute defaultAttribute, ClassOutputStream classOutputStream) {
            classOutputStream.write(defaultAttribute.info, 0, defaultAttribute.info.length);
            return null;
        }

        @Override
        public Void visitAnnotationDefault(AnnotationDefault_attribute annotationDefault_attribute, ClassOutputStream classOutputStream) {
            this.annotationWriter.write(annotationDefault_attribute.default_value, classOutputStream);
            return null;
        }

        @Override
        public Void visitCharacterRangeTable(CharacterRangeTable_attribute characterRangeTable_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(characterRangeTable_attribute.character_range_table.length);
            for (CharacterRangeTable_attribute.Entry entry : characterRangeTable_attribute.character_range_table) {
                this.writeCharacterRangeTableEntry(entry, classOutputStream);
            }
            return null;
        }

        protected void writeCharacterRangeTableEntry(CharacterRangeTable_attribute.Entry entry, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(entry.start_pc);
            classOutputStream.writeShort(entry.end_pc);
            classOutputStream.writeInt(entry.character_range_start);
            classOutputStream.writeInt(entry.character_range_end);
            classOutputStream.writeShort(entry.flags);
        }

        @Override
        public Void visitCode(Code_attribute code_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(code_attribute.max_stack);
            classOutputStream.writeShort(code_attribute.max_locals);
            classOutputStream.writeInt(code_attribute.code.length);
            classOutputStream.write(code_attribute.code, 0, code_attribute.code.length);
            classOutputStream.writeShort(code_attribute.exception_table.length);
            for (Code_attribute.Exception_data exception_data : code_attribute.exception_table) {
                this.writeExceptionTableEntry(exception_data, classOutputStream);
            }
            new AttributeWriter().write(code_attribute.attributes, classOutputStream);
            return null;
        }

        protected void writeExceptionTableEntry(Code_attribute.Exception_data exception_data, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(exception_data.start_pc);
            classOutputStream.writeShort(exception_data.end_pc);
            classOutputStream.writeShort(exception_data.handler_pc);
            classOutputStream.writeShort(exception_data.catch_type);
        }

        @Override
        public Void visitCompilationID(CompilationID_attribute compilationID_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(compilationID_attribute.compilationID_index);
            return null;
        }

        @Override
        public Void visitConstantValue(ConstantValue_attribute constantValue_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(constantValue_attribute.constantvalue_index);
            return null;
        }

        @Override
        public Void visitDeprecated(Deprecated_attribute deprecated_attribute, ClassOutputStream classOutputStream) {
            return null;
        }

        @Override
        public Void visitEnclosingMethod(EnclosingMethod_attribute enclosingMethod_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(enclosingMethod_attribute.class_index);
            classOutputStream.writeShort(enclosingMethod_attribute.method_index);
            return null;
        }

        @Override
        public Void visitExceptions(Exceptions_attribute exceptions_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(exceptions_attribute.exception_index_table.length);
            for (int n : exceptions_attribute.exception_index_table) {
                classOutputStream.writeShort(n);
            }
            return null;
        }

        @Override
        public Void visitInnerClasses(InnerClasses_attribute innerClasses_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(innerClasses_attribute.classes.length);
            for (InnerClasses_attribute.Info info : innerClasses_attribute.classes) {
                this.writeInnerClassesInfo(info, classOutputStream);
            }
            return null;
        }

        protected void writeInnerClassesInfo(InnerClasses_attribute.Info info, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(info.inner_class_info_index);
            classOutputStream.writeShort(info.outer_class_info_index);
            classOutputStream.writeShort(info.inner_name_index);
            this.writeAccessFlags(info.inner_class_access_flags, classOutputStream);
        }

        @Override
        public Void visitLineNumberTable(LineNumberTable_attribute lineNumberTable_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(lineNumberTable_attribute.line_number_table.length);
            for (LineNumberTable_attribute.Entry entry : lineNumberTable_attribute.line_number_table) {
                this.writeLineNumberTableEntry(entry, classOutputStream);
            }
            return null;
        }

        protected void writeLineNumberTableEntry(LineNumberTable_attribute.Entry entry, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(entry.start_pc);
            classOutputStream.writeShort(entry.line_number);
        }

        @Override
        public Void visitLocalVariableTable(LocalVariableTable_attribute localVariableTable_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(localVariableTable_attribute.local_variable_table.length);
            for (LocalVariableTable_attribute.Entry entry : localVariableTable_attribute.local_variable_table) {
                this.writeLocalVariableTableEntry(entry, classOutputStream);
            }
            return null;
        }

        protected void writeLocalVariableTableEntry(LocalVariableTable_attribute.Entry entry, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(entry.start_pc);
            classOutputStream.writeShort(entry.length);
            classOutputStream.writeShort(entry.name_index);
            classOutputStream.writeShort(entry.descriptor_index);
            classOutputStream.writeShort(entry.index);
        }

        @Override
        public Void visitLocalVariableTypeTable(LocalVariableTypeTable_attribute localVariableTypeTable_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeByte(localVariableTypeTable_attribute.local_variable_table.length);
            for (LocalVariableTypeTable_attribute.Entry entry : localVariableTypeTable_attribute.local_variable_table) {
                this.writeLocalVariableTypeTableEntry(entry, classOutputStream);
            }
            return null;
        }

        protected void writeLocalVariableTypeTableEntry(LocalVariableTypeTable_attribute.Entry entry, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(entry.start_pc);
            classOutputStream.writeShort(entry.length);
            classOutputStream.writeShort(entry.name_index);
            classOutputStream.writeShort(entry.signature_index);
            classOutputStream.writeShort(entry.index);
        }

        @Override
        public Void visitModule(Module_attribute module_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(module_attribute.module_name);
            return null;
        }

        @Override
        public Void visitModuleExportTable(ModuleExportTable_attribute moduleExportTable_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(moduleExportTable_attribute.export_type_table.length);
            for (int n : moduleExportTable_attribute.export_type_table) {
                classOutputStream.writeShort(n);
            }
            return null;
        }

        @Override
        public Void visitModuleMemberTable(ModuleMemberTable_attribute moduleMemberTable_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(moduleMemberTable_attribute.package_member_table.length);
            for (int n : moduleMemberTable_attribute.package_member_table) {
                classOutputStream.writeShort(n);
            }
            return null;
        }

        @Override
        public Void visitRuntimeVisibleAnnotations(RuntimeVisibleAnnotations_attribute runtimeVisibleAnnotations_attribute, ClassOutputStream classOutputStream) {
            this.annotationWriter.write(runtimeVisibleAnnotations_attribute.annotations, classOutputStream);
            return null;
        }

        @Override
        public Void visitRuntimeInvisibleAnnotations(RuntimeInvisibleAnnotations_attribute runtimeInvisibleAnnotations_attribute, ClassOutputStream classOutputStream) {
            this.annotationWriter.write(runtimeInvisibleAnnotations_attribute.annotations, classOutputStream);
            return null;
        }

        @Override
        public Void visitRuntimeVisibleParameterAnnotations(RuntimeVisibleParameterAnnotations_attribute runtimeVisibleParameterAnnotations_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeByte(runtimeVisibleParameterAnnotations_attribute.parameter_annotations.length);
            for (Annotation[] annotationArray : runtimeVisibleParameterAnnotations_attribute.parameter_annotations) {
                this.annotationWriter.write(annotationArray, classOutputStream);
            }
            return null;
        }

        @Override
        public Void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisibleParameterAnnotations_attribute runtimeInvisibleParameterAnnotations_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeByte(runtimeInvisibleParameterAnnotations_attribute.parameter_annotations.length);
            for (Annotation[] annotationArray : runtimeInvisibleParameterAnnotations_attribute.parameter_annotations) {
                this.annotationWriter.write(annotationArray, classOutputStream);
            }
            return null;
        }

        @Override
        public Void visitSignature(Signature_attribute signature_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(signature_attribute.signature_index);
            return null;
        }

        @Override
        public Void visitSourceDebugExtension(SourceDebugExtension_attribute sourceDebugExtension_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.write(sourceDebugExtension_attribute.debug_extension, 0, sourceDebugExtension_attribute.debug_extension.length);
            return null;
        }

        @Override
        public Void visitSourceFile(SourceFile_attribute sourceFile_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(sourceFile_attribute.sourcefile_index);
            return null;
        }

        @Override
        public Void visitSourceID(SourceID_attribute sourceID_attribute, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(sourceID_attribute.sourceID_index);
            return null;
        }

        @Override
        public Void visitStackMap(StackMap_attribute stackMap_attribute, ClassOutputStream classOutputStream) {
            if (this.stackMapWriter == null) {
                this.stackMapWriter = new StackMapTableWriter();
            }
            classOutputStream.writeShort(stackMap_attribute.entries.length);
            for (StackMap_attribute.stack_map_frame stack_map_frame2 : stackMap_attribute.entries) {
                this.stackMapWriter.write(stack_map_frame2, classOutputStream);
            }
            return null;
        }

        @Override
        public Void visitStackMapTable(StackMapTable_attribute stackMapTable_attribute, ClassOutputStream classOutputStream) {
            if (this.stackMapWriter == null) {
                this.stackMapWriter = new StackMapTableWriter();
            }
            classOutputStream.writeShort(stackMapTable_attribute.entries.length);
            for (StackMapTable_attribute.stack_map_frame stack_map_frame2 : stackMapTable_attribute.entries) {
                this.stackMapWriter.write(stack_map_frame2, classOutputStream);
            }
            return null;
        }

        @Override
        public Void visitSynthetic(Synthetic_attribute synthetic_attribute, ClassOutputStream classOutputStream) {
            return null;
        }

        protected void writeAccessFlags(AccessFlags accessFlags, ClassOutputStream classOutputStream) {
            this.sharedOut.writeShort(accessFlags.flags);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ConstantPoolWriter
    implements ConstantPool.Visitor<Integer, ClassOutputStream> {
        protected ConstantPoolWriter() {
        }

        protected int write(ConstantPool.CPInfo cPInfo, ClassOutputStream classOutputStream) {
            classOutputStream.writeByte(cPInfo.getTag());
            return cPInfo.accept(this, classOutputStream);
        }

        @Override
        public Integer visitClass(ConstantPool.CONSTANT_Class_info cONSTANT_Class_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(cONSTANT_Class_info.name_index);
            return 1;
        }

        @Override
        public Integer visitDouble(ConstantPool.CONSTANT_Double_info cONSTANT_Double_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeDouble(cONSTANT_Double_info.value);
            return 2;
        }

        @Override
        public Integer visitFieldref(ConstantPool.CONSTANT_Fieldref_info cONSTANT_Fieldref_info, ClassOutputStream classOutputStream) {
            this.writeRef(cONSTANT_Fieldref_info, classOutputStream);
            return 1;
        }

        @Override
        public Integer visitFloat(ConstantPool.CONSTANT_Float_info cONSTANT_Float_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeFloat(cONSTANT_Float_info.value);
            return 1;
        }

        @Override
        public Integer visitInteger(ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeInt(cONSTANT_Integer_info.value);
            return 1;
        }

        @Override
        public Integer visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info cONSTANT_InterfaceMethodref_info, ClassOutputStream classOutputStream) {
            this.writeRef(cONSTANT_InterfaceMethodref_info, classOutputStream);
            return 1;
        }

        @Override
        public Integer visitLong(ConstantPool.CONSTANT_Long_info cONSTANT_Long_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeLong(cONSTANT_Long_info.value);
            return 2;
        }

        @Override
        public Integer visitNameAndType(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(cONSTANT_NameAndType_info.name_index);
            classOutputStream.writeShort(cONSTANT_NameAndType_info.type_index);
            return 1;
        }

        @Override
        public Integer visitMethodref(ConstantPool.CONSTANT_Methodref_info cONSTANT_Methodref_info, ClassOutputStream classOutputStream) {
            return this.writeRef(cONSTANT_Methodref_info, classOutputStream);
        }

        @Override
        public Integer visitString(ConstantPool.CONSTANT_String_info cONSTANT_String_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(cONSTANT_String_info.string_index);
            return 1;
        }

        @Override
        public Integer visitUtf8(ConstantPool.CONSTANT_Utf8_info cONSTANT_Utf8_info, ClassOutputStream classOutputStream) {
            classOutputStream.writeUTF(cONSTANT_Utf8_info.value);
            return 1;
        }

        protected Integer writeRef(ConstantPool.CPRefInfo cPRefInfo, ClassOutputStream classOutputStream) {
            classOutputStream.writeShort(cPRefInfo.class_index);
            classOutputStream.writeShort(cPRefInfo.name_and_type_index);
            return 1;
        }
    }

    protected static class ClassOutputStream
    extends ByteArrayOutputStream {
        private DataOutputStream d = new DataOutputStream(this);

        public void writeByte(int n) {
            try {
                this.d.writeByte(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeShort(int n) {
            try {
                this.d.writeShort(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeInt(int n) {
            try {
                this.d.writeInt(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeLong(long l) {
            try {
                this.d.writeLong(l);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeFloat(float f) {
            try {
                this.d.writeFloat(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeDouble(double d) {
            try {
                this.d.writeDouble(d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeUTF(String string) {
            try {
                this.d.writeUTF(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeTo(ClassOutputStream classOutputStream) {
            try {
                super.writeTo(classOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

