import edu.rice.cs.mint.runtime.*;

public final class Limitations {
    public static class OpenWindow implements Runnable {
        public void run() { System.out.println("Open Window"); }
    }
    public static final class FinalOpenWindow implements Runnable {
        public void run() { System.out.println("Open Window"); }
    }
    
    public static OpenWindow cmd = new OpenWindow();
    public void run() {
        Code<Void> cv = <| { cmd.run(); } |>;
        cv.run();
        
        /*
         final OpenWindow cmd2 = new OpenWindow();
         cv = <| { cmd2.run(); } |>; // error: OpenWindow needs to be final w/out code
         cv.run();
         */
        
        final FinalOpenWindow cmd2 = new FinalOpenWindow();
        cv = <| { cmd2.run(); } |>;
        cv.run();
        
        /*
         final Runnable cmd3 = new FinalOpenWindow();
         cv = <| { cmd3.run(); } |>; // error: Runnable needs to be final w/out code
         cv.run();
         */
    }
    
    public static void main (String [] args) {
        new Limitations().run();
    }
}
