package hj.array.view;

import hj.array.SRegionRectangular;
import hj.lang.SArrayView;
import edu.rice.cs.mint.runtime.*;

public final class SDoubleArrayView extends SArrayView {
    public final SafeCode<double[]> baseArray;    
    
    public SDoubleArrayView(SafeCode<double[]> baseArray, int offset, SRegionRectangular r) {
        super(offset, r);
        this.baseArray = baseArray;
    }
    
   public final separable SafeCode<Double> get(final int i) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>))] |>;
    }
    
    
    public final separable SafeCode<Double> get(final int i, final int j) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>))] |>;
    }
    
    
    public final separable SafeCode<Double> get(final int i, final int j, final int k) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>))] |>;
    }
    
    public final separable SafeCode<Double> get(final int i, final int j, final int k, final int l) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>))] |>;
    }
    
    public final separable SafeCode<Double> get(final int i, final int j, final int k, final int l, final int m) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|m|>))] |>;
    }
    
    public final separable SafeCode<Void> set(final SafeCode<Double> r, final int i) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>))] = `(r); } |>;
    }
    
    
    public final separable SafeCode<Void> set(final SafeCode<Double> r, final int i, final int j) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>))] = `(r); } |>;
    }
    
    
    public final separable SafeCode<Void> set(final SafeCode<Double> r, final int i, final int j, final int k) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>))] = `(r); } |>;
    }
    
    public final separable SafeCode<Void> set(final SafeCode<Double> r, final int i, final int j, final int k, final int l) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>))] = `(r); } |>;
    }
    
    public final separable SafeCode<Void> set(final SafeCode<Double> r, final int i, final int j, final int k, final int l, final int m) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|m|>))] = `(r); } |>;
    }
    
}
