package hj.array.view.test;

import hj.lang.*;
import hj.array.*;
import hj.array.view.*;

import junit.framework.*;

public class DoubleArrayViewTest extends TestCase {
    public void testSingleton() {
        double[] ba = new double[1];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 0 }, 0));
        ba[0] = 1.0;
        assertEquals(1.0, v.get(0));
        
        v.set(3.0, 0);
        assertEquals(3.0, ba[0]);
    }
    
    public void test1by1() {
        double[] ba = new double[1];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 0, 0, 0 }, 0)); // 1x1
        ba[0] = 1.0;
        assertEquals(1.0, v.get(0, 0));
        
        v.set(3.0, 0, 0);
        assertEquals(3.0, ba[0]);
    }
    
    public void test2by1() {
        double[] ba = new double[2];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(1, 0));
        
        v.set(5.0, 0, 0);
        v.set(6.0, 1, 0);
        assertEquals(5.0, ba[0]);
        assertEquals(6.0, ba[1]);
    }
    
    public void test1by2() {
        double[] ba = new double[2];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(0, 1));
        v.set(5.0, 0, 0);
        v.set(6.0, 0, 1);
        assertEquals(5.0, ba[0]);
        assertEquals(6.0, ba[1]);
    }
    
    public void test3by1() {
        double[] ba = new double[3];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 2, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(1, 0));
        assertEquals(3.0, v.get(2, 0));
        v.set(5.0, 0, 0);
        v.set(6.0, 1, 0);
        v.set(7.0, 2, 0);
        assertEquals(5.0, ba[0]);
        assertEquals(6.0, ba[1]);
        assertEquals(7.0, ba[2]);
    }
    
    public void test1by3() {
        double[] ba = new double[3];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 0, 0, 2 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(0, 1));
        assertEquals(3.0, v.get(0, 2));
        
        v.set(5.0, 0, 0);
        v.set(6.0, 0, 1);
        v.set(7.0, 0, 2);
        assertEquals(5.0, ba[0]);
        assertEquals(6.0, ba[1]);
        assertEquals(7.0, ba[2]);
    }
    
    public void test3by2() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 2, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(0, 1));
        assertEquals(3.0, v.get(1, 0));
        assertEquals(4.0, v.get(1, 1));
        assertEquals(5.0, v.get(2, 0));
        assertEquals(6.0, v.get(2, 1));
        
        v.set(5.0, 0, 0);
        v.set(6.0, 0, 1);
        v.set(7.0, 1, 0);
        v.set(8.0, 1, 1);
        v.set(9.0, 2, 0);
        v.set(10.0, 2, 1);
        assertEquals(5.0, ba[0]);
        assertEquals(6.0, ba[1]);
        assertEquals(7.0, ba[2]);
        assertEquals(8.0, ba[3]);
        assertEquals(9.0, ba[4]);
        assertEquals(10.0, ba[5]);
    }
    
    public void test3by1viewOf3x2() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 2, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(1, 0));
        assertEquals(3.0, v.get(2, 0));
        
        v.set(5.0, 0, 0);
        v.set(7.0, 1, 0);
        v.set(9.0, 2, 0);
        assertEquals(5.0, ba[0]);
        assertEquals(7.0, ba[1]);
        assertEquals(9.0, ba[2]);
    }
    
    public void test3by1viewOf3x2b() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 3, new RegionRectangular(new int[] { 0, 2, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        assertEquals(4.0, v.get(0, 0));
        assertEquals(5.0, v.get(1, 0));
        assertEquals(6.0, v.get(2, 0));
        
        v.set(5.0, 0, 0);
        v.set(7.0, 1, 0);
        v.set(9.0, 2, 0);
        assertEquals(5.0, ba[3]);
        assertEquals(7.0, ba[4]);
        assertEquals(9.0, ba[5]);
    }
    
    public void test1by2viewOf3x2() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(0, 1));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 0, 1);
        assertEquals(7.0, ba[0]);
        assertEquals(8.0, ba[1]);
    }
    
    public void test1by2viewOf3x2b() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 2, new RegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        
        assertEquals(3.0, v.get(0, 0));
        assertEquals(4.0, v.get(0, 1));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 0, 1);
        assertEquals(7.0, ba[2]);
        assertEquals(8.0, ba[3]);
    }
    
    public void test1by2viewOf3x2c() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 4, new RegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        
        assertEquals(5.0, v.get(0, 0));
        assertEquals(6.0, v.get(0, 1));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 0, 1);
        assertEquals(7.0, ba[4]);
        assertEquals(8.0, ba[5]);
    }
    
    public void test2by2viewOf3x2() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 1, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(0, 1));
        assertEquals(3.0, v.get(1, 0));
        assertEquals(4.0, v.get(1, 1));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 0, 1);
        v.set(9.0, 1, 0);
        v.set(10.0, 1, 1);
        assertEquals(7.0, ba[0]);
        assertEquals(8.0, ba[1]);
        assertEquals(9.0, ba[2]);
        assertEquals(10.0, ba[3]);
    }
    
    public void test2by2viewOf3x2b() {
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 2, new RegionRectangular(new int[] { 0, 1, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
                
        assertEquals(3.0, v.get(0, 0));
        assertEquals(4.0, v.get(0, 1));
        assertEquals(5.0, v.get(1, 0));
        assertEquals(6.0, v.get(1, 1));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 0, 1);
        v.set(9.0, 1, 0);
        v.set(10.0, 1, 1);
        assertEquals(7.0, ba[2]);
        assertEquals(8.0, ba[3]);
        assertEquals(9.0, ba[4]);
        assertEquals(10.0, ba[5]);
    }
    
    public void test2by1viewOf3x2() {
        // |12|3
        //  45 6
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 0, new RegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        assertEquals(1.0, v.get(0, 0));
        assertEquals(2.0, v.get(1, 0));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 1, 0);
        assertEquals(7.0, ba[0]);
        assertEquals(8.0, ba[1]);
    }
    
    public void test2by1viewOf3x2b() {
        // 1|23|
        // 4 56
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 1, new RegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        assertEquals(2.0, v.get(0, 0));
        assertEquals(3.0, v.get(1, 0));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 1, 0);
        assertEquals(7.0, ba[1]);
        assertEquals(8.0, ba[2]);
    }
    
    public void test2by1viewOf3x2c() {
        //  12 3
        // |45|6
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 3, new RegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        assertEquals(4.0, v.get(0, 0));
        assertEquals(5.0, v.get(1, 0));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 1, 0);
        assertEquals(7.0, ba[3]);
        assertEquals(8.0, ba[4]);
    }
    
    public void test2by1viewOf3x2d() {
        // 1 23
        // 4|56|
        double[] ba = new double[6];
        DoubleArrayView v = new DoubleArrayView(ba, 4, new RegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        ba[4] = 5.0;
        ba[5] = 6.0;
        assertEquals(5.0, v.get(0, 0));
        assertEquals(6.0, v.get(1, 0));
        
        v.set(7.0, 0, 0);
        v.set(8.0, 1, 0);
        assertEquals(7.0, ba[4]);
        assertEquals(8.0, ba[5]);
    }
}
