package edu.rice.cs.mint.comp;

import edu.rice.cs.mint.comp.com.sun.tools.javac.code.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symbol.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.JCTree.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JCDiagnostic.DiagnosticPosition;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.List;
import edu.rice.cs.mint.comp.com.sun.tools.javac.comp.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Type.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.jvm.Target;
import edu.rice.cs.mint.comp.javax.lang.model.element.ElementKind;

import static edu.rice.cs.mint.comp.com.sun.tools.javac.code.Flags.*;
import static edu.rice.cs.mint.comp.com.sun.tools.javac.code.Kinds.*;
import static edu.rice.cs.mint.comp.com.sun.tools.javac.code.TypeTags.*;
import static edu.rice.cs.mint.comp.com.sun.tools.javac.util.ListBuffer.lb;

/** This pass translates Mint to Generic Java.
 */
public class TransStaging extends TreeTranslator {
    /** The context key for the TransStaging phase. */
    protected static final Context.Key<TransStaging> transStagingKey =
        new Context.Key<TransStaging>();

    /** Get the instance for this context. */
    public static TransStaging instance(Context context) {
        TransStaging instance = context.get(transStagingKey);
        if (instance == null)
            instance = new TransStaging(context);
        return instance;
    }

    private Options options;
    private Names names;
    private Log log;
    private Symtab syms;
    private TreeMaker make;
    private Enter enter;
    private Types types;
    private final Resolve rs;
    private DiagnosticPosition make_pos;
    private Target target;
    private int curLevel;
    private List<BracketInfo> brackets;
    private static int genSymNum = 0;

    /** The current method symbol.
     */
    MethodSymbol currentMethodSym = null;

    /** The currently enclosing class.
     */
    ClassSymbol currentClass = null;

    /** Environment for symbol lookup, set by translateTopLevelClass.
     */
    Env<AttrContext> attrEnv;

    protected TransStaging(Context context) {
        context.put(transStagingKey, this);
        names = Names.instance(context);
        log = Log.instance(context);
        syms = Symtab.instance(context);
        enter = Enter.instance(context);
        Source source = Source.instance(context);
        types = Types.instance(context);
        make = TreeMaker.instance(context);
        rs = Resolve.instance(context);
        target = Target.instance(context);
        options = Options.instance(context);
    }

    // mgr: staging additions

    JCExpression makeMSPTreeCode (java.util.List<MSPTreeCodeSerializer.Elem> elems,
                                  Type rettype, boolean isStat, boolean isSafe,
                                  final JCExpression inputTree) {
        final List<VarSymbol> classVarsInScope = (inputTree instanceof JCBracketExpr)?
            ((JCBracketExpr)inputTree).classVarsInScope:((JCBracketStat)inputTree).classVarsInScope;
        ListBuffer<JCExpression> mspForest = ListBuffer.lb ();
        for (MSPTreeCodeSerializer.Elem elem : elems) {
            if (elem instanceof MSPTreeCodeSerializer.StringElem) {
                // create a string literal for the code
                JCExpression code =
                    makeLit (syms.stringType,
                             ((MSPTreeCodeSerializer.StringElem) elem).contents);
                // create the expression: new StringMSPTree (code)
                mspForest.append (makeNewClass (syms.stringMspTreeType,
                                                null,
                                                List.of (code)));
            }
            else if (elem instanceof MSPTreeCodeSerializer.EscapeElem) {
                // extract the mspTree from code
                JCExpression escape_tree = translate (((MSPTreeCodeSerializer.EscapeElem) elem).contents);
                JCExpression tree =
                    makeCall (FullyQualIdent(syms.mspTreeCodeType.tsym),
                              names.fromString ("escape"),
                              List.of (escape_tree));
                mspForest.append (tree);
            }
            else if (elem instanceof MSPTreeCodeSerializer.EscapeStatElem) {
                // extract the mspTree from code
                JCExpression escape_tree = translate (((MSPTreeCodeSerializer.EscapeStatElem) elem).contents);
                Type t = escape_tree.type;
                if ((t instanceof ClassType) &&
                    ((t.tsym == syms.safeCodeType.tsym) || (t.tsym == syms.codeType.tsym)) &&
                    (t.getTypeArguments().nonEmpty()) && (t.getTypeArguments().head.tsym == syms.javaLangVoidType.tsym)) {
                    // Code<Void> or SafeCode<Void>
                    JCExpression tree =
                        makeCall (FullyQualIdent(syms.mspTreeCodeType.tsym),
                                  names.fromString ("escape"),
                                  List.of (escape_tree));
                    mspForest.append (tree);
                }
                else if ((t instanceof ClassType) &&
                         ((t.tsym == syms.safeCodeType.tsym) || (t.tsym == syms.codeType.tsym)) &&
                         (t.getTypeArguments().nonEmpty()) && !(t.getTypeArguments().head instanceof Type.CapturedType)) {
                    // Code<T> or SafeCode<T> where T is not Void or ?:
                    // Escape expression used as a statement. for example:
                    // Code<Integer> x = <| 1 |>; <| { `x; } |>
                    // What we will generate is <| { { Object temp = (1); } } |>
                    
                    // create a string literal for "{ Object temp = "
                    JCExpression tree = makeLit (syms.stringType, "{ Object "+genSym("discardedResult")+" = ");
                    // create the expression: new StringMSPTree (code)
                    mspForest.append (makeNewClass (syms.stringMspTreeType,
                                                    null,
                                                    List.of (tree)));

                    // escape statement
                    tree = makeCall (noAnonymousFullyQualIdent(syms.mspTreeCodeType.tsym),
                                     names.fromString ("escape"),
                                     List.of (escape_tree));
                    mspForest.append (tree);
                    
                    // create a string literal for "; } "
                    tree = makeLit (syms.stringType, "; } ");
                    // create the expression: new StringMSPTree (code)
                    mspForest.append (makeNewClass (syms.stringMspTreeType,
                                                    null,
                                                    List.of (tree)));
                }
                else {
                    // Code<?> or SafeCode<?>:
                    // Escape expression used as a statement. for example:
                    // Code<?> x = <| 1 |>; <| { `x; } |>
                    // What we will generate is <| { { Object temp = (1); } } |>
                    
                    // create a string literal for "{ Object temp = "
//                    String tempSym = genSym("tempResult");
//                    JCExpression tree = makeLit (syms.stringType, "{ edu.rice.cs.mint.runtime.Code<?> "+tempSym+" = "+escape_tree+";\n"+
//                                                 "System.out.println(((edu.rice.cs.mint.runtime.MSPTreeCode)"+tempSym+").isStat); }");
                    JCExpression tree = makeLit (syms.stringType, "{ "+escape_tree+".run(); }");
                    // create the expression: new StringMSPTree (code)
                    mspForest.append (makeNewClass (syms.stringMspTreeType,
                                                    null,
                                                    List.of (tree)));
                }
            }
            else if (elem instanceof MSPTreeCodeSerializer.CspElem) {
                // extract the variable
                JCIdent orig_var = ((MSPTreeCodeSerializer.CspElem) elem).contents;
                Type t = orig_var.type;
                // System.out.println("orig_var: "+orig_var+", cspCount="+orig_var.cspCount);
                // create a new identifier, copy the varGenSym but decrement the csp count
                JCIdent csp_var = makeIdent(orig_var.sym, t);
                csp_var.cspCount = orig_var.cspCount-1;
                csp_var.genVarSym = orig_var.genVarSym;
                // System.out.println("csp_var: "+csp_var+", cspCount="+csp_var.cspCount);
                JCExpression csp_expr = csp_var;
                // if the type of the CSP variable is primitive, box it
                if (t.isPrimitive()) {
                  t = types.boxedClass(t).type;
                  csp_expr = boxIfNeeded(csp_expr, t);
                  // System.out.println("csp_var after boxing: "+csp_expr);
                }
                JCExpression csp_type_name = makeLit(syms.stringType,
                                                     t.toString());
                
                // check that the type doesn't contain an anonymous class
                if (containsAnonymousClass(t)) {
                    // error
                    log.error(inputTree.pos(), "fully.qualified.identifier.was.anonymous", t.toString());
                }
                
                // create the expression: new CspMSPTree (code)
                mspForest.append (makeNewClass (syms.cspMspTreeType,
                                                null,
                                                List.of (csp_expr, csp_type_name)));
            }
            else if (elem instanceof MSPTreeCodeSerializer.StringExprElem) {
                // create an identifier with the name of the symbol
                // JCExpression code = makeIdent(((MSPTreeCodeSerializer.StringExprElem)elem).contents, syms.stringType);
                JCExpression code = ((MSPTreeCodeSerializer.StringExprElem)elem).contents;
                // create the expression: new StringMSPTree (code)
                mspForest.append (makeNewClass (syms.stringMspTreeType,
                                                null,
                                                List.of (code)));
            }
//            else if (elem instanceof MSPTreeCodeSerializer.CspSymElem) {
//                MSPTreeCodeSerializer.CspSymElem cspSymElem = (MSPTreeCodeSerializer.CspSymElem)elem;
//                Type t = cspSymElem.type;
//                // create an identifier with the name of the symbol
//                JCExpression csp_var = makeIdent(cspSymElem.contents, t);
//
//                // if the type of the CSP variable is primitive, box it
//                if (t.isPrimitive()) {
//                  t = types.boxedClass(t).type;
//                  csp_var = boxIfNeeded(csp_var, t);
//                }
//                JCExpression csp_type_name = makeLit(syms.stringType,
//                                                     t.toString());
//                // create the expression: new CspMSPTree (code)
//                mspForest.append (makeNewClass (syms.cspMspTreeType,
//                                                null,
//                                                List.of (csp_var, csp_type_name)));
//            }
            else {
                // FIXME
                throw new AssertionError ();
            }
        }

        // create the expression new InternalMSPTree ({... nodes ...})
        JCExpression mspForestExpr =
            make.NewArray (make.Type (syms.mspTreeType),
                           // List.of (makeLit (syms.intType, elems.size ())),
                           List.<JCExpression>nil(),
                           mspForest.toList ())
                .setType(new ArrayType(syms.mspTreeType, syms.arrayClass));
        JCExpression isStatVal = makeLit (syms.booleanType, isStat ? 1 : 0);
        JCExpression mspTreeExpr =
            makeNewClass (syms.internalMspTreeType, null, List.of (mspForestExpr, isStatVal));

        // create expressions for the arguments
        JCExpression retTypeVal = rettype.accept(new Type.Visitor<JCExpression,Void>() {
            public JCExpression concatStringExpr(JCExpression e1, JCExpression e2) {
                // TODO: extend this to take a list of JCExpressions and statically concat adjacent string literals
                if ((e1 instanceof JCLiteral) && (e2 instanceof JCLiteral)) {
                    JCLiteral l1 = (JCLiteral)e1;
                    JCLiteral l2 = (JCLiteral)e2;
                    return makeLit(syms.stringType, ((String)l1.value)+((String)l2.value));
                }
                else {
                    return makeCall(e1, names.fromString ("concat"), List.of (e2));
                }
            }
            public JCExpression visitClassType(ClassType t, Void s) {
                String className = t.tsym.getQualifiedName().toString();
                if (t.tsym.name.isEmpty()) {
                    // this code was copied from Type.toString()'s className() helper
                    ClassType norm = (ClassType) t.tsym.type;
                    if (norm == null) {
                        className = "Object";
                    } else if (norm.interfaces_field != null && norm.interfaces_field.nonEmpty()) {
                        className = norm.interfaces_field.head.toString();
                    } else {
                        className = norm.supertype_field.toString();
                    }
                }
                if (t.getEnclosingType().tag == CLASS && t.tsym.owner.kind == TYP) {
                    className = t.getEnclosingType().toString() + "." + className;
                }
                JCExpression retExpr = makeStringLit(className);
                if (t.getTypeArguments().nonEmpty()) {
                    retExpr = concatStringExpr(retExpr, makeStringLit("<"));
                    boolean first = true;
                    for(Type typeArg: t.getTypeArguments()) {
                        JCExpression typeArgExpr = typeArg.accept(this, null);
                        if (first) { first = false; }
                        else { retExpr = concatStringExpr(retExpr, makeStringLit(",")); }
                        retExpr = concatStringExpr(retExpr, typeArgExpr);
                    }
                    retExpr = concatStringExpr(retExpr, makeStringLit(">"));
                }
                return retExpr;
            }
            public JCExpression visitWildcardType(WildcardType t, Void s) {
                JCExpression retExpr = makeStringLit(t.kind.toString());
                if (t.kind != BoundKind.UNBOUND)
                    retExpr = concatStringExpr(retExpr, t.type.accept(this, null));
                return retExpr;
            }
            public JCExpression visitArrayType(ArrayType t, Void s) {
                return concatStringExpr(t.elemtype.accept(this, null), makeStringLit("[]"));
            }
            public JCExpression visitMethodType(MethodType t, Void s) {
                throw new IllegalArgumentException("MethodType "+t+" encountered in Code type");
            }
            public JCExpression visitPackageType(PackageType t, Void s) {
                return makeStringLit(t.tsym.getQualifiedName().toString());
            }
            public JCExpression visitTypeVar(TypeVar t, Void s) {
                // look at classVarsInScope to find a VarSymbol that we can use for this type variable
                // and call Class.getName on it
                // System.out.println("TypeVar "+t);
                VarSymbol found = null;
                for(VarSymbol vs: classVarsInScope) {
                    // System.out.println("    comparing t.tsym "+t.tsym+" and vs.type.getTypeArguments().head.tsym "+
                    //                    vs.type.getTypeArguments().head.tsym+" : "+
                    //                    (t.tsym==vs.type.getTypeArguments().head.tsym));
                    if (t.tsym==vs.type.getTypeArguments().head.tsym) {
                        found = vs;
                        // System.out.println("======> FOUND "+vs);
                        break;
                    }
                }
                if (found==null) {
                    // System.out.println("==> ERROR: no Class<"+t+"> found in scope");
                    log.error(inputTree.pos(), "type.variable.without.class.variable.in.scope.used.in.brackets",
                              t.toString());
                    return makeStringLit(t.toString());
                }
                
                // use myClassOfT.getName().replace('$','.') to get the name of the type
                JCMethodInvocation getNameCall = makeCall(makeIdent(found, found.type),
                                                          names.fromString("getName"),
                                                          List.<JCExpression>nil());
                JCMethodInvocation replaceCall = makeCall(getNameCall,
                                                          names.fromString("replace"),
                                                          List.<JCExpression>of(makeLit(syms.charType, (int)'$'),
                                                                                makeLit(syms.charType, (int)'.')));
                // System.out.println("    using: "+replaceCall);
                return replaceCall;
            }
            public JCExpression visitCapturedType(CapturedType t, Void s) {
                // this is something like: capture#979 of ? extends java.lang.Object
                // here, we just use the bound: java.lang.Object
                return t.wildcard.type.accept(this, null);
            }
            public JCExpression visitForAll(ForAll t, Void s) {
                throw new IllegalArgumentException("ForAll "+t+" encountered in Code type");
            }
            public JCExpression visitUndetVar(UndetVar t, Void s) {
                throw new IllegalArgumentException("UndetType "+t+" encountered in Code type");
            }
            public JCExpression visitErrorType(ErrorType t, Void s) {
                throw new IllegalArgumentException("ErrorType "+t+" encountered in Code type");
            }
            public JCExpression visitType(Type t, Void s) {
                return makeStringLit(t.toString());
            }
        }, null);

        // return the expression new MSPTreeCode (mspForest, string name of T, isStat)
        // or new SafeMSPTreeCode (...) if bracket is safe
        Type bracketType = isSafe?syms.safeMspTreeCodeType:syms.mspTreeCodeType;
        Type codeOfRetType = new ClassType (bracketType.getEnclosingType(),
                                            List.of(rettype), bracketType.tsym);
        return makeNewClass(codeOfRetType,
                            List.of (rettype), 
                            List.of (mspTreeExpr, retTypeVal, isStatVal));
    }

    public void visitBracketExpr(JCBracketExpr tree) {
        pushBracket(tree);

        tree.body = translate(tree.body);
        
        java.util.List<MSPTreeCodeSerializer.Elem> elems =
            new MSPTreeCodeSerializer(syms, make, names, log, rs, make_pos, attrEnv, tree.classVarsInScope).
            serializeExpr(tree.body);

        Type t = tree.body.type;
        if (t.isPrimitive()) {
            t = types.boxedClass(t).type;
        }
        result = createBracketLets(makeMSPTreeCode (elems, t, false, tree.safe, tree));
        
        popBracket();
    }

    public void visitBracketStat(JCBracketStat tree) {
        pushBracket(tree);

        tree.body = translate(tree.body);

        java.util.List<MSPTreeCodeSerializer.Elem> elems =
            new MSPTreeCodeSerializer(syms, make, names, log, rs, make_pos, attrEnv, tree.classVarsInScope).
            serializeStats(tree.body);
        
        result = createBracketLets(makeMSPTreeCode (elems, syms.javaLangVoidType, true, tree.safe, tree));
        
        popBracket();
    }
    
    protected JCExpression createBracketLets(JCExpression tree) {
        for(JCVariableDecl decl: brackets.head.genSyms) {
            JCExpression prefix_tree =
                makeLit (syms.stringType, decl.name.toString());
            JCExpression rval =
                makeCall ( FullyQualIdent (syms.mspTreeCodeType.tsym),
                          names.fromString ("varGenSym"),
                          List.of (prefix_tree));

            JCVariableDecl def = make.VarDef(decl.genVarSym, rval);
            JCExpression temp = make.LetExpr(def, tree);
            temp.type = tree.type;
            tree = temp;
        }
        return tree;
    }
    
    public void visitEscapeExpr(JCEscapeExpr tree) {
        enterEscape();
        
        tree.body = translate(tree.body);
        result = tree;

        leaveEscape();
    }

    public void visitEscapeStat(JCEscapeStat tree) {
        enterEscape();

        tree.body = translate(tree.body);
        result = tree;
        
        leaveEscape();
    }
    
    public void visitVarDef(JCVariableDecl tree) {
        if ((curLevel>0) && (currentMethodSym!=null)) {
            // find the closest enclosing bracket with the same level
            BracketInfo closest = null;
            for(BracketInfo bi: brackets) {
                if (bi.level==curLevel) {
                    closest = bi;
                    break;
                }
            }
            if (closest==null) throw new AssertionError("Did not find bracket with same level for variable definition.");
//            System.out.println("Closest bracket for "+tree+" is at level "+closest.level+" - "+closest.bracket);
            Name varName = names.fromString(genSym(tree.name.toString()));
            tree.genVarSym = new VarSymbol(FINAL|SYNTHETIC, varName, syms.stringType, closest.bracketMethodSym);
            closest.genSyms = closest.genSyms.prepend(tree);
        }

        super.visitVarDef(tree);
    }

    public void visitSelect(JCFieldAccess tree) {
        super.visitSelect(tree);
        if (brackets.size()>0) {
            if (tree.name==names._this) {
                boolean availableInThis = currentClass.isSubClass(tree.sym.owner, types);
//                System.out.println(tree.selected+" name "+tree.name+" sym.owner "+tree.sym.owner+" available? "+availableInThis);
                if (!availableInThis) {
                    log.error(tree.pos(), "may.not.access.enclosing.this");
                }
            }
        }
    }
    
    public void visitIdent(JCIdent tree) {
        JCExpression exprResult;
        if (tree.sym.kind == VAR) {
            if (curLevel>0) {
//                System.out.println("Looking for "+tree);
                // find the closest enclosing bracket with a variable declaration for this identifier
                BracketInfo closest = null;
                JCVariableDecl binding = null;
                for(BracketInfo bi: brackets) {
                    for(JCVariableDecl decl: bi.genSyms) {
                        if (decl.name.toString().equals(tree.name.toString())) {
                            closest = bi;
                            binding = decl;
                            break;
                        }
                    }
                }
                if (closest!=null) {
//                    System.out.println("Closest declaration for "+tree+" is "+binding+" at level "+closest.level+" - "+closest.bracket);
                    tree.genVarSym = binding.genVarSym;
                }
//                else {
//                    throw new AssertionError("Did not find bracket with variable definition.");
//                }
            }
        }
        // super.visitIdent(tree);
        exprResult = tree;
        
        // if we are inside brackets, fully qualify symbols
        if (brackets.size()>0) {
//            System.out.println(tree);
            if ((tree.sym.kind == TYP) && (tree.sym.type.tag != TYPEVAR)) {
                // use fully qualified identifiers for classes and interfaces, but NOT for type variables
                try {
                    exprResult = noAnonymousFullyQualIdent(tree.sym);
                    exprResult.type = tree.type;
                }
                catch(IllegalArgumentException iae) { log.error(tree.pos(), "fully.qualified.identifier.was.anonymous", tree.sym.toString()); }
            }
            else if (tree.sym.kind == MTH) {
                if ((tree.sym.flags() & STATIC)!=0) {
//                    System.out.println("\tMTH static type="+tree.sym.type+" owner="+tree.sym.owner);
                    try {
                        exprResult = make.Select(noAnonymousFullyQualIdent(tree.sym.owner), tree.sym);
                    }
                    catch(IllegalArgumentException iae) { log.error(tree.pos(), "fully.qualified.identifier.was.anonymous", tree.sym.owner.toString()); }
                }
                else {
                    boolean availableInThis = currentClass.isSubClass(tree.sym.owner, types);
//                    System.out.println("\tMTH non-static type="+tree.sym.type+" owner="+tree.sym.owner+" available in this? "+
//                                       availableInThis);
                    if (!availableInThis) {
                        log.error(tree.pos(), "not.yet.supported.by.mint", "use of the `this' of an enclosing class in "+tree);
                    }
                }
//                System.out.println("\t--> "+exprResult);
            }
            else if ((tree.sym.kind == VAR) && (tree.sym.getKind() == ElementKind.FIELD)) {
                if ((tree.sym.flags() & STATIC)!=0) {
//                    System.out.println("\tVAR static type="+tree.sym.type+" owner="+tree.sym.owner);
                    try {
                        exprResult = make.Select(noAnonymousFullyQualIdent(tree.sym.owner), tree.sym);
                    }
                    catch(IllegalArgumentException iae) { log.error(tree.pos(), "fully.qualified.identifier.was.anonymous", tree.sym.owner.toString()); }
                }
                else {
                    boolean availableInThis = currentClass.isSubClass(tree.sym.owner, types);
//                    System.out.println("\tVAR non-static type="+tree.sym.type+" owner="+tree.sym.owner+" available in this? "+
//                                       availableInThis);
                    if (!availableInThis) {
                        log.error(tree.pos(), "not.yet.supported.by.mint", "use of the `this' of an enclosing class in "+tree);
                    }
                }
//                System.out.println("\t--> "+exprResult);
            }
        }
        
        result = exprResult;
        
        if ((tree.cspCount>0) && (!tree.lifted)) {
            if (edu.rice.cs.mint.comp.com.sun.tools.javac.comp.Attr._isPrimitiveOrBoxedOrString(tree.type, types, syms)) {
                tree.lifted = true;
                String methodName = "lift"+tree.type.tsym.name.toString();
                JCMethodInvocation liftCall = makeCall(FullyQualIdent(syms.liftType.tsym),
                                                       names.fromString(methodName),
                                                       List.of(exprResult));
                JCExpression escapedLiftCall = make.EscapeExpr(liftCall);
                result = escapedLiftCall;
                result.type = tree.type;
            }
        }
    }
    
    public void visitClassDef(JCClassDecl tree) {
        ClassSymbol currentClassPrev = currentClass;
        MethodSymbol currentMethodSymPrev = currentMethodSym;
        currentClass = tree.sym;
        currentMethodSym = null;
        
        super.visitClassDef(tree);
        
        currentClass = currentClassPrev;
        currentMethodSym = currentMethodSymPrev;
    }
    
    public void visitMethodDef(JCMethodDecl tree) {
        MethodSymbol prevMethodSym = currentMethodSym;
        
        currentMethodSym = tree.sym;
        super.visitMethodDef(tree);
        
        currentMethodSym = prevMethodSym;
    }
     
    protected void pushBracket(JCExpression tree) {
        // put tree on brackets list
        ++curLevel;
        brackets = brackets.prepend(new BracketInfo(tree,curLevel,currentMethodSym));
//        System.out.println("pushBrackets: level "+brackets.head.level+" - "+brackets.head.bracket);
    }
    
    protected void popBracket() {
        // remove tree from brackets list
        --curLevel;
//        System.out.println("popBrackets: level back to "+curLevel+" - "+brackets.head.bracket);
        brackets = brackets.tail;
    }
    
    protected void enterEscape() {
        // decrement current level
        --curLevel;
//        System.out.println("enterEscape: decreased level to "+curLevel);
    }

    protected void leaveEscape() {
        // restore current level
        ++curLevel;
//        System.out.println("leaveEscape: restored level to "+curLevel);
    }
    
    protected String genSym(String prefix) {
        return prefix+"$$"+(++genSymNum);
    }
    
    // copied from Lower.java

    /** Translate a toplevel class definition.
     *  @param cdef    The definition to be translated.
     */
    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree cdef, TreeMaker make) {
        // note that this method does NOT support recursion.
        this.make = make;
        this.attrEnv = env;
        this.curLevel = 0;
        this.brackets = List.<BracketInfo>nil();
        JCTree res = translate(cdef);

        if (options.get("-verbose") != null) { System.out.println(res); }
        return res;
    }
    
    /** Visitor method: Translate a single node.
     *  Attach the source position from the old tree to its replacement tree.
     */
    public <T extends JCTree> T translate(T tree) {
        if (tree == null) {
            return null;
        } else {
            make_at(tree.pos());
            T result = super.translate(tree);
            return result;
        }
    }

    /** Equivalent to make.at(pos.getStartPosition()) with side effect of caching
      *  pos as make_pos, for use in diagnostics.
      **/
    TreeMaker make_at(DiagnosticPosition pos) {
        make_pos = pos;
        return make.at(pos);
    }

    /** Make an attributed tree representing a literal. This will be an
     *  Ident node in the case of boolean literals, a Literal node in all
     *  other cases.
     *  @param type       The literal's type.
     *  @param value      The literal's value.
     */
    JCExpression makeLit(Type type, Object value) {
        return make.Literal(type.tag, value).setType(type.constType(value));
    }

    /** Make an attributed tree representing a string literal.
     *  @param value      The literal's value.
     */
    JCExpression makeStringLit(String value) {
        return make.Literal(syms.stringType.tag, value).setType(syms.stringType.constType(value));
    }
    
    /** Make an attributed tree representing an identifier. */
    JCIdent makeIdent(Symbol sym, Type t) {
        JCIdent ident = make.Ident(sym.name);
        ident.setType(t);
        ident.sym = sym;
        return ident;
    }
    
     /** Create a fully-qualified identifier from a symbol.
     */
    public JCExpression FullyQualIdent(Symbol sym) {
        return (sym.name == names.empty ||
                sym.owner == null ||
                sym.owner.name == names.empty ||
                sym.owner.kind == MTH || sym.owner.kind == VAR)
            ? make.Ident(sym)
            : make.Select(FullyQualIdent(sym.owner), sym);
    }
    
    /** Create a fully-qualified identifier from a symbol. Throws an IllegalArgumentException if part of the symbol is anonymous.
      */
    public JCExpression noAnonymousFullyQualIdent(Symbol sym) {
        if (sym.name == names.empty ||
            sym.owner == null ||
            sym.owner.name == names.empty ||
            sym.owner.kind == MTH || sym.owner.kind == VAR) {
            return make.Ident(sym); // fully qualified
        }
        else {
            // not fully qualified, create a select statement
            if (sym.owner instanceof ClassSymbol) {
                ClassSymbol c = (ClassSymbol)sym.owner;
                if (c.fullname.isEmpty()) {
                    throw new IllegalArgumentException("Anonymous");
                }
            }
            JCExpression owner = noAnonymousFullyQualIdent(sym.owner);
            return make.Select(owner, sym);
        }
    }

    /** Returns true if any part of the type is an anonymous class.
      */
    public boolean containsAnonymousClass(Type t) {
        Type enclosingType = t;
        if ((enclosingType!=null) && (enclosingType.tsym!=null) && (enclosingType.tsym.name.isEmpty())) {
            // System.out.println("Anonymous: "+t);
            return true;
        }
        enclosingType = enclosingType.getEnclosingType();        
        // if (enclosingType!=null) {
        //     System.out.println("enclosingType.tag == CLASS? "+(enclosingType.tag == CLASS));
        //     System.out.println("enclosingType.tsym.owner.kind == TYP? "+(enclosingType.tsym.owner.kind == TYP));
        // }
        while ((enclosingType !=null) &&
               (enclosingType.tag == CLASS) &&
               (enclosingType.tsym.owner.kind == TYP)) {
            // System.out.println("In loop, checking "+enclosingType);
            if ((enclosingType!=null) && (enclosingType.tsym!=null) && (enclosingType.tsym.name.isEmpty())) {
                // System.out.println("Anonymous: "+enclosingType);
                return true;
            }
            enclosingType = enclosingType.getEnclosingType();
            // System.out.println("enclosingType.tag == CLASS? "+(enclosingType.tag == CLASS));
            // System.out.println("enclosingType.tsym.owner.kind == TYP? "+(enclosingType.tsym.owner.kind == TYP));
        }
        if ((enclosingType!=null) && (enclosingType.tsym!=null) && (enclosingType.tsym.name.isEmpty())) {
            // System.out.println("Anonymous: "+enclosingType);
            return true;
        }
        return false;
    }
    
    /** Make an attributed class instance creation expression.
     *  @param ctype    The class type.
     *  @param args     The constructor arguments.
     */
    JCNewClass makeNewClass(Type ctype, List<Type> typeargtypes, List<JCExpression> args) {
        JCExpression s = FullyQualIdent(ctype.tsym);
        // System.out.println("make.QualIdent(ctype.tsym) returns: "+s);
        List<JCExpression> typeargexprs = null;
        if (typeargtypes!=null) {
            ListBuffer<JCExpression> buf = lb();
            for(Type tat: typeargtypes) {
                buf.add(make.Type (tat));
            }
            typeargexprs = buf.toList();
        }
        JCNewClass tree = make.NewClass(null,
            typeargexprs, s, args, null);
        // System.out.println("make.NewClass returns: "+tree);
        tree.constructor = rs.resolveConstructor(
            make_pos, attrEnv, ctype, TreeInfo.types(args), typeargtypes, false, false);
        tree.type = ctype;
        return tree;
    }

    /** Create an attributed tree of the form left.name(). */
    private JCMethodInvocation makeCall(JCExpression left, Name name, List<JCExpression> args) {
        assert left.type != null;
        Symbol funcsym = lookupMethod(make_pos, name, left.type,
                                      TreeInfo.types(args));
        return make.App(make.Select(left, funcsym), args);
    }

    /** Look up a method in a given scope.
     */
    private MethodSymbol lookupMethod(DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return rs.resolveInternalMethod(pos, attrEnv, qual, name, args, null);
    }

    /** Look up a constructor.
     */
    private MethodSymbol lookupConstructor(DiagnosticPosition pos, Type qual, List<Type> args) {
        return rs.resolveInternalConstructor(pos, attrEnv, qual, args, null);
    }

    /** Expand a boxing or unboxing conversion if needed. */
    @SuppressWarnings("unchecked") // XXX unchecked
    <T extends JCTree> T boxIfNeeded(T tree, Type type) {
        boolean havePrimitive = tree.type.isPrimitive();
        if (havePrimitive == type.isPrimitive())
            return tree;
        if (havePrimitive) {
            Type unboxedTarget = types.unboxedType(type);
            if (unboxedTarget.tag != NONE) {
                if (!types.isSubtype(tree.type, unboxedTarget))
                    tree.type = unboxedTarget; // e.g. Character c = 89;
                return (T)boxPrimitive((JCExpression)tree, type);
            } else {
                tree = (T)boxPrimitive((JCExpression)tree);
            }
        } else {
            tree = (T)unbox((JCExpression)tree, type);
        }
        return tree;
    }

    /** Box up a single primitive expression. */
    JCExpression boxPrimitive(JCExpression tree) {
        return boxPrimitive(tree, types.boxedClass(tree.type).type);
    }

    /** Box up a single primitive expression. */
    JCExpression boxPrimitive(JCExpression tree, Type box) {
        make_at(tree.pos());
        if (target.boxWithConstructors()) {
            Symbol ctor = lookupConstructor(tree.pos(),
                                            box,
                                            List.<Type>nil()
                                            .prepend(tree.type));
            return make.Create(ctor, List.of(tree));
        } else {
            Symbol valueOfSym = lookupMethod(tree.pos(),
                                             names.valueOf,
                                             box,
                                             List.<Type>nil()
                                             .prepend(tree.type));
            return make.App(make.QualIdent(valueOfSym), List.of(tree));
        }
    }

    /** Unbox an object to a primitive value. */
    JCExpression unbox(JCExpression tree, Type primitive) {
        Type unboxedType = types.unboxedType(tree.type);
        // note: the "primitive" parameter is not used.  There muse be
        // a conversion from unboxedType to primitive.
        make_at(tree.pos());
        Symbol valueSym = lookupMethod(tree.pos(),
                                       unboxedType.tsym.name.append(names.Value), // x.intValue()
                                       tree.type,
                                       List.<Type>nil());
        return make.App(make.Select(tree, valueSym));
    }
    
    protected static class BracketInfo {
        public JCExpression bracket;
        public int level;
        public List<JCVariableDecl> genSyms;
        public MethodSymbol bracketMethodSym;
        public BracketInfo(JCExpression bracket, int level, MethodSymbol bracketMethodSym) {
            this.bracket = bracket;
            this.level = level;
            this.bracketMethodSym = bracketMethodSym;
            genSyms = List.<JCVariableDecl>nil();
        }
    }
}
