package edu.rice.cs.mint.runtime.mspTree;

import java.util.ArrayList;

import edu.rice.cs.mint.comp.com.sun.tools.javac.util.*;

public abstract class MSPTree {
    /**
     * Returns a pair of a string and a list of object-string pairs:
     * The string is the code for the method body.
     * The list of object-string pairs contains information about CSP values:
     * The object is the actual value, the string is the type.
     */
    public Pair<String,ArrayList<Pair<Object,String>>> generateCodeCspPair () {
        StringBuffer code_buf = new StringBuffer ();
        ArrayList<Pair<Object,String>> csp_table = new ArrayList<Pair<Object,String>> ();
        generateCodeCspPair (code_buf, csp_table);
        return Pair.of (code_buf.toString(), csp_table);
    }
    public abstract void generateCodeCspPair (StringBuffer code_buf,
                                              ArrayList<Pair<Object,String>> csp_table);
}
