package edu.rice.cs.mint.runtime;

import edu.rice.cs.mint.runtime.mspTree.*;

public class Lift {            
    public static final Code<Byte> liftbyte(final byte value) {
        return new MSPTreeCode<Byte>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Byte", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Byte> liftByte(final Byte value) {
        return new MSPTreeCode<Byte>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Byte", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Character> liftchar(final char value) {
        return new MSPTreeCode<Character>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Character", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Character> liftCharacter(final Character value) {
        return new MSPTreeCode<Character>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Character", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Short> liftshort(final short value) {
        return new MSPTreeCode<Short>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Short", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Short> liftShort(final Short value) {
        return new MSPTreeCode<Short>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Short", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Integer> liftint(final int value) {
        return new MSPTreeCode<Integer>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Integer", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Integer> liftInteger(final Integer value) {
        return new MSPTreeCode<Integer>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Integer", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Long> liftlong(final long value) {
        return new MSPTreeCode<Long>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Long", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Long> liftLong(final Long value) {
        return new MSPTreeCode<Long>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Long", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Float> liftfloat(final float value) {
        return new MSPTreeCode<Float>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Float", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Float> liftFloat(final Float value) {
        return new MSPTreeCode<Float>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Float", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Double> liftdouble(final double value) {
        return new MSPTreeCode<Double>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Double", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Double> liftDouble(final Double value) {
        return new MSPTreeCode<Double>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Double", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Boolean> liftboolean(final boolean value) {
        return new MSPTreeCode<Boolean>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Boolean", /*retTypeName*/
             false /*isStat*/);
    }
    public static final Code<Boolean> liftBoolean(final Boolean value) {
        return new MSPTreeCode<Boolean>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree(String.valueOf(value)) }, false /*isStat*/), /*mspTree*/
             "Boolean", /*retTypeName*/
             false /*isStat*/);
    }    
    public static final Code<String> liftString(final String value) {
        return new MSPTreeCode<String>
            (new InternalMSPTree(new MSPTree[] { new StringMSPTree("\""+String.valueOf(value)+"\"") }, false /*isStat*/), /*mspTree*/
             "String", /*retTypeName*/
             false /*isStat*/);
    }
}
