package edu.rice.cs.mint.runtime;

import java.util.HashMap;
import java.util.Queue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.JCTree.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.parser.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.code.Symbol.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.comp.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.main.*;
import edu.rice.cs.mint.comp.com.sun.tools.javac.jvm.ClassWriter;

public class StringCodeCompiler extends JavaCompiler {
    protected StringCodeCompiler (Context context) {
        super (context);
    }

    public static void preRegister (final Context context) {
        context.put(compilerKey, new Context.Factory<JavaCompiler>() {
                public JavaCompiler make() {
                    return new StringCodeCompiler (context);
                }
            });
    }
    
    /* write a class as an array of bytes */
    protected byte [] genBytes (Env<AttrContext> env, JCClassDecl cdef) {
        ByteArrayOutputStream out = new ByteArrayOutputStream ();
        edu.rice.cs.mint.comp.javax.tools.JavaFileObject prev = log.useSource(env.enclClass.sym.sourcefile != null ?
                                              env.enclClass.sym.sourcefile :
                                              env.toplevel.sourcefile);
        try {
            if (gen.genClass(env, cdef)) {
                writer.writeClassFile (out, cdef.sym);
            }
            else {
                /* should never happen */
                System.err.println ("Internal error in StringCodeCompiler.genBytes: gen.genClass returned false");
                System.exit (1);
            }
        } catch (IOException e) {
            /* should never happen */
            System.err.println ("Internal error in StringCodeCompiler.genBytes");
            e.printStackTrace (System.err);
            System.exit (1);
        } catch (ClassWriter.PoolOverflow e) {
            System.err.println ("pool overflow in run");
            e.printStackTrace (System.err);
            System.exit (1);
        } catch (ClassWriter.StringOverflow e) {
            System.err.println ("string overflow in run");
            e.printStackTrace (System.err);
            System.exit (1);
        } catch (CompletionFailure e) {
            System.err.println ("completion failure in run");
            e.printStackTrace (System.err);
            System.exit (1);
        } finally {
          log.useSource(prev);
        }
        return out.toByteArray ();
    }

    /* write a list of classes as a hash map from names to arrays of bytes */
    protected HashMap<String,byte[]> generateBytes (Queue<Pair<Env<AttrContext>, JCClassDecl>> queue) {
        HashMap<String,byte[]> hash = new HashMap<String,byte[]> ();

        for (Pair<Env<AttrContext>, JCClassDecl> pair: queue) {
            String className = pair.snd.sym.getQualifiedName().toString ();
            if (pair.snd.sym.name.isEmpty()) {
                // anonymous
                className = pair.snd.sym.flatname.toString();
            }
//            System.out.println("Compiling "+className);
            hash.put (className, genBytes (pair.fst, pair.snd));
        }

        return hash;
    }

    /* parse an input string and compile it to a class name along with a
     * hash map of bytes for definitions of the class and classes it contains */
    public HashMap<String,byte[]> compileStringToBytes (String classname, String code) {
        /* first make a parser */
        Parser parser = parserFactory.newParser (code, false, false, false);

        /* now parse to a top-level JCCompilationUnit */
        JCCompilationUnit tree = parse (new StringJavaFileObject (classname, code));

        /* enter classes into the symbol table */
        enter.main (List.of (tree));

        /* FIXME: should we process annotations...? */
        /* processAnnotations (Collections.singletonList (tree)); */

        /* now compile to a hash-table of bytes */
        return generateBytes (desugar (flow (attribute (todo))));
    }
}
