/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.runtime;

import edu.rice.cs.mint.runtime.ClassCode;
import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.MSPTreeCode;
import edu.rice.cs.mint.runtime.mspTree.InternalMSPTree;
import edu.rice.cs.mint.runtime.mspTree.MSPTree;
import edu.rice.cs.mint.runtime.mspTree.StringMSPTree;
import java.lang.reflect.Field;

public final class FieldCode<T, R> {
    private Field field;
    private Class<?> type;

    public FieldCode(Field field) {
        this.field = field;
        this.type = field.getType();
        if (field.getType().isPrimitive()) {
            if (this.type == Byte.TYPE) {
                this.type = Byte.class;
            } else if (this.type == Character.TYPE) {
                this.type = Character.class;
            } else if (this.type == Short.TYPE) {
                this.type = Short.class;
            } else if (this.type == Integer.TYPE) {
                this.type = Integer.class;
            } else if (this.type == Long.TYPE) {
                this.type = Long.class;
            } else if (this.type == Float.TYPE) {
                this.type = Float.class;
            } else if (this.type == Double.TYPE) {
                this.type = Double.class;
            } else if (this.type == Boolean.TYPE) {
                this.type = Boolean.class;
            }
        }
    }

    public Code<R> get(Code<T> code) {
        return new MSPTreeCode(new InternalMSPTree(new MSPTree[]{MSPTreeCode.escape(code), new StringMSPTree("." + this.field.getName())}, false), this.type.getName(), false);
    }

    public ClassCode<R> getFieldClassCode() {
        return new ClassCode(this.type);
    }
}

