/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.file;

import edu.rice.cs.mint.comp.com.sun.tools.javac.file.FSInfo;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFSInfo
extends FSInfo {
    static CacheFSInfo singleton;
    private Map<File, Entry> cache = new ConcurrentHashMap<File, Entry>();

    public static void preRegister(final Context context) {
        context.put(FSInfo.class, new Context.Factory<FSInfo>(){

            @Override
            public FSInfo make() {
                if (singleton == null) {
                    singleton = new CacheFSInfo();
                }
                context.put(FSInfo.class, singleton);
                return singleton;
            }
        });
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public File getCanonicalFile(File file) {
        Entry entry = this.getEntry(file);
        return entry.canonicalFile;
    }

    @Override
    public boolean exists(File file) {
        Entry entry = this.getEntry(file);
        return entry.exists;
    }

    @Override
    public boolean isDirectory(File file) {
        Entry entry = this.getEntry(file);
        return entry.isDirectory;
    }

    @Override
    public boolean isFile(File file) {
        Entry entry = this.getEntry(file);
        return entry.isFile;
    }

    @Override
    public List<File> getJarClassPath(File file) throws IOException {
        Entry entry = this.getEntry(file);
        if (entry.jarClassPath == null) {
            entry.jarClassPath = super.getJarClassPath(file);
        }
        return entry.jarClassPath;
    }

    private Entry getEntry(File file) {
        Entry entry = this.cache.get(file);
        if (entry == null) {
            entry = new Entry();
            entry.canonicalFile = super.getCanonicalFile(file);
            entry.exists = super.exists(file);
            entry.isDirectory = super.isDirectory(file);
            entry.isFile = super.isFile(file);
            this.cache.put(file, entry);
        }
        return entry;
    }

    private static class Entry {
        File canonicalFile;
        boolean exists;
        boolean isFile;
        boolean isDirectory;
        List<File> jarClassPath;

        private Entry() {
        }
    }
}

