/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.util;

import edu.rice.cs.mint.comp.com.sun.tools.javac.api.DiagnosticFormatter;
import edu.rice.cs.mint.comp.com.sun.tools.javac.file.JavacFileManager;
import edu.rice.cs.mint.comp.com.sun.tools.javac.tree.JCTree;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.AbstractLog;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.BasicDiagnosticFormatter;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.ClientCodeException;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Context;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JCDiagnostic;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JavacMessages;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Options;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Pair;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.RawDiagnosticFormatter;
import edu.rice.cs.mint.comp.javax.tools.DiagnosticListener;
import edu.rice.cs.mint.comp.javax.tools.JavaFileObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log
extends AbstractLog {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    public final int MaxErrors;
    public final int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean dumpOnError;
    public boolean multipleErrors;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    public Set<String> expectDiagKeys;
    private JavacMessages messages;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();

    @Deprecated
    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        super(JCDiagnostic.Factory.instance(context));
        DiagnosticListener diagnosticListener;
        context.put(logKey, this);
        this.errWriter = printWriter;
        this.warnWriter = printWriter2;
        this.noticeWriter = printWriter3;
        Options options = Options.instance(context);
        this.dumpOnError = options.get("-doe") != null;
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-Xlint:none") == null;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
        boolean bl = options.get("rawDiagnostics") != null;
        this.messages = JavacMessages.instance(context);
        this.diagFormatter = bl ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this.messages);
        this.diagListener = diagnosticListener = context.get(DiagnosticListener.class);
        String string = options.get("expectKeys");
        if (string != null) {
            this.expectDiagKeys = new HashSet<String>(Arrays.asList(string.split(", *")));
        }
    }

    private int getIntOption(Options options, String string, int n) {
        String string2 = options.get(string);
        try {
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter printWriter = context.get(outKey);
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err);
            context.put(outKey, printWriter);
        }
        return printWriter;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter printWriter) {
        this(context, printWriter, printWriter, printWriter);
    }

    public static Log instance(Context context) {
        Log log = context.get(logKey);
        if (log == null) {
            log = new Log(context);
        }
        return log;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject javaFileObject, Map<JCTree, Integer> map) {
        javaFileObject.getClass();
        this.getSource(javaFileObject).setEndPosTable(map);
    }

    public JavaFileObject currentSourceFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    protected boolean shouldReport(JavaFileObject javaFileObject, int n) {
        boolean bl;
        if (this.multipleErrors || javaFileObject == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> pair = new Pair<JavaFileObject, Integer>(javaFileObject, n);
        boolean bl2 = bl = !this.recorded.contains(pair);
        if (bl) {
            this.recorded.add(pair);
        }
        return bl;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int n, PrintWriter printWriter) {
        String string;
        String string2 = string = this.source == null ? null : this.source.getLine(n);
        if (string == null) {
            return;
        }
        int n2 = this.source.getColumnNumber(n, false);
        Log.printLines(printWriter, string);
        for (int i = 0; i < n2 - 1; ++i) {
            printWriter.print(string.charAt(i) == '\t' ? "\t" : " ");
        }
        printWriter.println("^");
        printWriter.flush();
    }

    public static void printLines(PrintWriter printWriter, String string) {
        int n;
        while ((n = string.indexOf(10)) != -1) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        if (string.length() != 0) {
            printWriter.println(string);
        }
    }

    @Override
    protected void directError(String string, Object ... objectArray) {
        Log.printLines(this.errWriter, Log.getLocalizedString(string, objectArray));
        this.errWriter.flush();
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.writeDiagnostic(this.diags.warning(this.source, diagnosticPosition, string, objectArray));
        ++this.nwarnings;
    }

    @Override
    public void report(JCDiagnostic jCDiagnostic) {
        if (this.expectDiagKeys != null) {
            this.expectDiagKeys.remove(jCDiagnostic.getCode());
        }
        switch (jCDiagnostic.getType()) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                if (!this.emitWarnings && !jCDiagnostic.isMandatory()) break;
                this.writeDiagnostic(jCDiagnostic);
                break;
            }
            case WARNING: {
                if (!this.emitWarnings && !jCDiagnostic.isMandatory() || this.nwarnings >= this.MaxWarnings) break;
                this.writeDiagnostic(jCDiagnostic);
                ++this.nwarnings;
                break;
            }
            case ERROR: {
                if (this.nerrors >= this.MaxErrors || !this.shouldReport(jCDiagnostic.getSource(), jCDiagnostic.getIntPosition())) break;
                this.writeDiagnostic(jCDiagnostic);
                ++this.nerrors;
            }
        }
    }

    protected void writeDiagnostic(JCDiagnostic jCDiagnostic) {
        if (this.diagListener != null) {
            try {
                this.diagListener.report(jCDiagnostic);
                return;
            }
            catch (Throwable throwable) {
                throw new ClientCodeException(throwable);
            }
        }
        PrintWriter printWriter = this.getWriterForDiagnosticType(jCDiagnostic.getType());
        Log.printLines(printWriter, this.diagFormatter.format(jCDiagnostic, this.messages.getCurrentLocale()));
        if (this.promptOnError) {
            switch (jCDiagnostic.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType diagnosticType) {
        switch (diagnosticType) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String string, Object ... objectArray) {
        return JavacMessages.getDefaultLocalizedString("compiler.misc." + string, objectArray);
    }

    private void printRawError(int n, String string) {
        if (this.source == null || n == -1) {
            Log.printLines(this.errWriter, "error: " + string);
        } else {
            int n2 = this.source.getLineNumber(n);
            JavaFileObject javaFileObject = this.source.getFile();
            if (javaFileObject != null) {
                Log.printLines(this.errWriter, JavacFileManager.getJavacFileName(javaFileObject) + ":" + n2 + ": " + string);
            }
            this.printErrLine(n, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int n, String string) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSourceFile(), n)) {
            this.printRawError(n, string);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int n, String string) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(n, "warning: " + string);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format((Locale)null, string, objectArray);
    }
}

