/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.javax.lang.model.util;

import edu.rice.cs.mint.comp.javax.lang.model.element.Element;
import edu.rice.cs.mint.comp.javax.lang.model.element.ElementKind;
import edu.rice.cs.mint.comp.javax.lang.model.element.ExecutableElement;
import edu.rice.cs.mint.comp.javax.lang.model.element.PackageElement;
import edu.rice.cs.mint.comp.javax.lang.model.element.TypeElement;
import edu.rice.cs.mint.comp.javax.lang.model.element.VariableElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFilter {
    private static Set<ElementKind> CONSTRUCTOR_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.CONSTRUCTOR));
    private static Set<ElementKind> FIELD_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT));
    private static Set<ElementKind> METHOD_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.METHOD));
    private static Set<ElementKind> PACKAGE_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.PACKAGE));
    private static Set<ElementKind> TYPE_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE));

    private ElementFilter() {
    }

    public static List<VariableElement> fieldsIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, FIELD_KINDS, VariableElement.class);
    }

    public static Set<VariableElement> fieldsIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, FIELD_KINDS, VariableElement.class);
    }

    public static List<ExecutableElement> constructorsIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> constructorsIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static List<ExecutableElement> methodsIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, METHOD_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> methodsIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, METHOD_KIND, ExecutableElement.class);
    }

    public static List<TypeElement> typesIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, TYPE_KINDS, TypeElement.class);
    }

    public static Set<TypeElement> typesIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, TYPE_KINDS, TypeElement.class);
    }

    public static List<PackageElement> packagesIn(Iterable<? extends Element> iterable) {
        return ElementFilter.listFilter(iterable, PACKAGE_KIND, PackageElement.class);
    }

    public static Set<PackageElement> packagesIn(Set<? extends Element> set) {
        return ElementFilter.setFilter(set, PACKAGE_KIND, PackageElement.class);
    }

    private static <E extends Element> List<E> listFilter(Iterable<? extends Element> iterable, Set<ElementKind> set, Class<E> clazz) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Element element : iterable) {
            if (!set.contains((Object)element.getKind())) continue;
            arrayList.add(clazz.cast(element));
        }
        return arrayList;
    }

    private static <E extends Element> Set<E> setFilter(Set<? extends Element> set, Set<ElementKind> set2, Class<E> clazz) {
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>();
        for (Element element : set) {
            if (!set2.contains((Object)element.getKind())) continue;
            linkedHashSet.add(clazz.cast(element));
        }
        return linkedHashSet;
    }
}

