/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapClassLoader
extends ClassLoader {
    private static volatile HashMapClassLoader _instance = null;
    protected HashMap<String, byte[]> _classTable = new HashMap();
    private final String _classPathPropertyName;
    private String _classPathPropertyValue = null;

    public static synchronized HashMapClassLoader instance() {
        return HashMapClassLoader.instance("java.class.path");
    }

    public static synchronized HashMapClassLoader instance(String string) {
        if (_instance == null) {
            _instance = new HashMapClassLoader(string);
        }
        return _instance;
    }

    public static synchronized HashMapClassLoader instance(HashMap<String, byte[]> hashMap) {
        HashMapClassLoader hashMapClassLoader = HashMapClassLoader.instance();
        hashMapClassLoader.add(hashMap);
        return hashMapClassLoader;
    }

    private HashMapClassLoader(String string) {
        super(Thread.currentThread().getContextClassLoader());
        this._classPathPropertyName = string;
        this.updateClassPathProperty();
    }

    public void add(HashMap<String, byte[]> hashMap) {
        this._classTable.putAll(hashMap);
    }

    public byte[] getClassBytes(String string) {
        byte[] byArray = this._classTable.get(string);
        if (byArray == null) {
            URL uRL = this.findResource(string.replace('.', '/') + ".class");
            if (uRL == null) {
                return null;
            }
            try {
                byArray = this.toByteArray(uRL.openStream());
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return byArray;
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        return super.loadClass(string, bl);
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        byte[] byArray = this._classTable.get(string);
        if (byArray == null) {
            URL uRL = this.findResource(string.replace('.', '/') + ".class");
            if (uRL == null) {
                throw new ClassNotFoundException(string);
            }
            try {
                byArray = this.toByteArray(uRL.openStream());
                Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
                return clazz;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string);
            }
        }
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        if (n == -1) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2 = 0;
            do {
                if ((n2 += n) < 0) {
                    n2 = Integer.MAX_VALUE;
                }
                byteArrayOutputStream.write(byArray, 0, n);
            } while ((n = inputStream.read(byArray)) != -1);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public String getClassPathPropertyValue() {
        return this._classPathPropertyValue;
    }

    private void updateClassPathProperty() {
        if (this._classPathPropertyName == null) {
            return;
        }
        this._classPathPropertyValue = System.getProperty(this._classPathPropertyName);
        if (this._classPathPropertyValue == null) {
            return;
        }
    }
}

