/* an implementation of ClassCode<T> */

package edu.rice.cs.mint.runtime;

import edu.rice.cs.mint.runtime.mspTree.*;
import java.lang.reflect.*;

/**
 * NOTE: The methods and constructors in this class can be called from a separable context,
 * even though they are not declared as separable.
 */
public final class FieldCode<T,R> {
    private Field field;
    private Class<?> type;
    public FieldCode(Field field) {
        this.field = field;
        type = field.getType();
        if (field.getType().isPrimitive()) {
            if (type==Byte.TYPE) type = Byte.class;
            else if (type==Character.TYPE) type = Character.class;
            else if (type==Short.TYPE) type = Short.class;
            else if (type==Integer.TYPE) type = Integer.class;
            else if (type==Long.TYPE) type = Long.class;
            else if (type==Float.TYPE) type = Float.class;
            else if (type==Double.TYPE) type = Double.class;
            else if (type==Boolean.TYPE) type = Boolean.class;
        }
    }
    public Code<R> get(Code<T> o) {
        return new MSPTreeCode<R>(new InternalMSPTree(new MSPTree[] { MSPTreeCode.escape(o), new StringMSPTree("."+field.getName()) }, false /*isStat*/), /*mspTree*/
                                  type.getName(), /*retTypeName*/
                                  false /*isStat*/);
    }
    @SuppressWarnings("unchecked")
    public ClassCode<R> getFieldClassCode() {
        return new ClassCode<R>((Class<R>)type);
    }
}
