package edu.rice.cs.mint.runtime.mspTree;

import java.util.ArrayList;

import edu.rice.cs.mint.comp.com.sun.tools.javac.util.*;

public class InternalMSPTree extends MSPTree {
    public MSPTree [] mspForest;
    public boolean isStat;
    
    public InternalMSPTree (MSPTree [] mspForest, boolean isStat) {
        this.mspForest = mspForest;
        this.isStat = isStat;
    }
    
    public void generateCodeCspPair (StringBuffer code_buf,
                                     ArrayList<Pair<Object,String>> csp_table) {
        if (!isStat) {
            // insert parentheses around escapes to get precedence right
            code_buf.append ("(");
        }
        for (MSPTree tree : mspForest) {
            tree.generateCodeCspPair (code_buf, csp_table);
        }
        if (!isStat) {
            code_buf.append (")");
        }
    }
}

