import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.CodeFree;

import java.util.List;

public class CodeFreeSample {
    // -- final --
    
    public static final class FinalCodeFreeButNotMarked {
        int i;
    }
    
    public static class ContainsFinalCodeFree implements CodeFree {
        FinalCodeFreeButNotMarked fin;
    }
    
    public static void main(String[] args) {
        final FinalCodeFreeButNotMarked x = new FinalCodeFreeButNotMarked();
        Code<FinalCodeFreeButNotMarked> cx = <| x |>;
    }
    
    // -- from final to CodeFree --
    
    public static class CodeFreeCycle implements CodeFree {
        CodeFreeCycle2 m() { return null; }
    }
    public static final class CodeFreeCycle2 {
        CodeFreeCycle f;
    }
}
