//this is a version of Fib.java that has been modified to be used with Benchmark.java in order to perform timings

import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.SafeCode;
import edu.rice.cs.mint.util.Benchmark;

public class Fib_Let {
    
    public static int fib(int x,int y, int n){
        if (n == 0)
            return x;
        else
            return let int z = x + y; fib(y,z,n-1);
    }
    
    public static separable SafeCode<Integer> sfib(SafeCode<Integer> x,
                                                   SafeCode<Integer> y,
                                                   int n){
        if (n == 0)
            return x;
        else
            return <| let final int z = `x + `y; `(sfib(y, <| z |>, n - 1)) |>;
    }
    
    public static void main(String[] args) {
        System.out.println("fib(2,3,17)");
        Benchmark.TimedTask[] results =
            Benchmark.benchmark(Benchmark.stagingTasks(new Benchmark.Task() {
            public void run() {
                //
                // call unstaged code here
                //
                int i = fib(2,3,17);
                //
                //
                //
            }
        }, new Benchmark.Thunk<Code<? extends Benchmark.Task>>() {
            public Code<? extends Benchmark.Task> value() {
                return <| new Benchmark.Task() {
                    public void run() {
                        //
                        // splice in staged code here
                        //
                        int i = `(sfib(<| 2 |>, <| 3 |>, 17));
                        //
                        //
                        //
                    }
                } |>;
            }
        }));
        
//        Benchmark.print(0, results); // relative to unstaged
//        System.out.println();
        Benchmark.print(results.length-1, results); // relative to staged
    }
}

