//this is a version of Power.java that has been modified to be used with Benchmark.java in order to perform timings

import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.SafeCode;
import edu.rice.cs.mint.util.Benchmark;

public class Power4 {
    public static int power(int x, int n){
        if (n == 1)
            return x;
        else
            return x * power(x, n-1);
    }
    
    public static separable Code<Integer> spower(SafeCode<Integer> x, int n){
        if (n == 1)
            return x;
        else
            return <| `x * `(spower(x, n-1)) |>;
    }
    
    public void run() {
        System.out.println("power(2,17)");
        Benchmark.TimedTask[] results =
            Benchmark.benchmark(Benchmark.stagingTasks(new Benchmark.Task() {
            public void run() {
                //
                // call unstaged code here
                //
                power(2, 17);
                //
                //
                //
            }
        }, new Benchmark.Thunk<Code<? extends Benchmark.Task>>() {
            public Code<? extends Benchmark.Task> value() {
                return <| new Benchmark.Task() {
                    public void run() {
                        //
                        // splice in staged code here
                        //
                        int i = `(spower(<| 2 |>, 17));
                        //
                        //
                        //
                    }
                } |>;
            }
        }));
        
//        Benchmark.print(0, results); // relative to unstaged
//        System.out.println();
        Benchmark.print(results.length-1, results); // relative to staged
    }
    
    public static void main(String[] args) {
        new Power4().run();
    }
}

