import edu.rice.cs.mint.runtime.*;

public class NotWeakSepSample {
    public static class C {
	public Code<C> c;
    }

    public static class CodeContainerException extends RuntimeException {
	public CodeContainerException(Code<C> c) {
	    _c = c;
	}
	private Code<C> _c;
    }

    public static interface CodeThunk {
	public separable Code<Object> apply();
    }

    public static void main(String[] args) {
	Code<Object> co = <|
	    let final C y = null;
	`(new CodeThunk() {
		public separable Code<C> foo (final C x) {
		    x.c = <|y|>; // x.c is not code-free
		    // CodeContainerException takes a non-code-free
		    // argument
		    throw new CodeContainerException (<|y|>);
		    return <|x|>; // C is not code-free
		}
	       
		public separable Code<Object> apply() {
		    return <| new Object() |>;
		} 
	    }.apply()) |>;
    }
}