import edu.rice.cs.mint.runtime.*;

public class SeparableInnerClassSample {
    public static interface IntFun {
        public separable int apply(int x);
    }  
    
    public Code<? extends IntFun> getFunction() {
        return <| new IntFun() {
            public separable int apply(int x) {
                System.out.println("anonymous DoubleFun.apply("+x+")"); // ERROR
                return 2*x;
            }
        } |>;
    }

    public Code<? extends IntFun> getFunction2() {
        final Code<Integer> ci = <| 2 |>;
        return <| new IntFun() {
            public separable int apply(int x) {
                return (`ci)*x; // ERROR
            }
        } |>;
    }

    public Code<? extends IntFun> getFunction3() {
        final SafeCode<Integer> sci = <| 2 |>;
        return <| new IntFun() {
            public separable int apply(int x) {
                return (`sci)*x; // OK
            }
        } |>;
    }

    public Code<? extends IntFun> getFunction4() {
        final Code<Integer> ci = <| 2 |>;
        return <| new IntFun() {
            public int nonSepApply(int x) {
                return (`ci)*x; // OK
            }
            public separable int apply(int x) {
                return 2*x;
            }
        } |>;
    }
}
