package hj.array.view;

import hj.array.RegionRectangular;
import hj.lang.ArrayView;

public class ComplexArrayView extends ArrayView {
 
 public ComplexArrayView(int offset, RegionRectangular r) {
  super(offset * 2, adaptBoundariesForComplex(r));
 }
 
 /**
  * Adapt region boundary so that we can use the doubled size
  * runtime representation of the complex64 array.
  * Ideally this should be handled by the compiler and we shouldn't
  * have to deal with this at runtime.
  * @param r
  * @return
  */
 public static RegionRectangular adaptBoundariesForComplex(RegionRectangular r){
  final int [] dimensions = new int [r.rank * 2];
  RegionRectangular rr = (RegionRectangular) r;

  if (r.rank == 1) { 
   dimensions[0] = rr.low_I;
   dimensions[1] = ((rr.low_I + rr.lg_I)*2)-1;
  }

  if (r.rank == 2) {
   dimensions[0] = rr.low_I;
   dimensions[1] = (rr.low_I + rr.lg_I)-1;
   dimensions[2] = rr.low_J;
   dimensions[3] = (rr.low_J + rr.lg_J*2)-1;
  }

  if (r.rank == 3) {
   dimensions[0] = rr.low_I;
   dimensions[1] = (rr.low_I + rr.lg_I)-1;
   dimensions[2] = rr.low_J;
   dimensions[3] = (rr.low_J + rr.lg_J)-1;
   dimensions[4] = rr.low_K;
   dimensions[5] = (rr.low_K + rr.lg_K*2)-1;
  }

  RegionRectangular newRegion =  new RegionRectangular(dimensions, rr.base);
  return newRegion;
 }
 
 public separable int getRowOffset(int i) {
  //compute new offset
  return (region.ordinal(i, region.low_J) / 2);
 }
 
 public separable int getRowOffset(int i, int j) {
  //compute new offset
  return (region.ordinal(i, j, region.low_K) / 2);
 }


}
