package hj.array.view;

import habanero.bhp.complex64;
import hj.array.RegionRectangular;

public final class ComplexDoubleArrayView extends ComplexArrayView {

 public final double [] baseArray;

 
 public ComplexDoubleArrayView(double [] baseArray, int offset, RegionRectangular r) {
  super(offset, r);
  this.baseArray = baseArray;
 }
 

 public final double get(final int i) {
  return baseArray[offset + this.region.ordinal(i)];
 }


 public final double get(final int i, final int j) {
  return baseArray[offset + this.region.ordinal(i,j)];
 }


 public final double get(final int i, final int j, final int k) {
  return baseArray[offset + this.region.ordinal(i,j,k)];
 }

 public final double get(final int i, final int j, final int k, final int l) {
  return baseArray[offset + this.region.ordinal(i,j,k,l)];
 }

 public final double get(final int i, final int j, final int k, final int l, final int m) {
  return baseArray[offset + this.region.ordinal(i,j,k,l,m)];
 }

 public final void set(double r, final int i) {
  baseArray[offset + this.region.ordinal(i)] = r;
 }


 public final void set(double r, final int i, final int j) {
  baseArray[offset + this.region.ordinal(i,j)] = r;
 }


 public final void set(double r, final int i, final int j, final int k) {
  baseArray[offset + this.region.ordinal(i,j,k)] = r;
 }

 public final void set(double r, final int i, final int j, final int k, final int l) {
  baseArray[offset + this.region.ordinal(i,j,k,l)] = r;
 }

 public final void set(double r, final int i, final int j, final int k, final int l, final int m) {
  baseArray[offset + this.region.ordinal(i,j,k,l,m)] = r;
 }

 
 public final complex64 getc64(final int i) {
  return new complex64(baseArray[offset + this.region.ordinal(2*i)],
                       baseArray[offset + this.region.ordinal(2*i+1)]);
 }

 public final complex64 getc64(final int i, final int j) {
  return new complex64(baseArray[offset + this.region.ordinal(i,2*j)],
                       baseArray[offset + this.region.ordinal(i,2*j+1)]);
 }


 public final complex64 getc64(final int i, final int j, final int k) {
  return new complex64(baseArray[offset + this.region.ordinal(i,j,2*k)],
                       baseArray[offset + this.region.ordinal(i,j,2*k+1)]);
 }

 public final complex64 getc64(final int i, final int j, final int k, final int l) {
  return new complex64(baseArray[offset + this.region.ordinal(i,j,k,2*l)],
                       baseArray[offset + this.region.ordinal(i,j,k,2*l+1)]);
 }

 public final complex64 getc64(final int i, final int j, final int k, final int l, final int m) {
  return new complex64(baseArray[offset + this.region.ordinal(i,j,k,l,2*m)],
                       baseArray[offset + this.region.ordinal(i,j,k,l,2*m+1)]);
 }

 public final void setc64(complex64 r, final int i) {
  baseArray[offset + this.region.ordinal(2*i)] = r.real;
  baseArray[offset + this.region.ordinal(2*i+1)] = r.imag;
 }


 public final void setc64(complex64 r, final int i, final int j) {
  baseArray[offset + this.region.ordinal(i,2*j)] = r.real;
  baseArray[offset + this.region.ordinal(i,2*j+1)] = r.imag;
 }


 public final void setc64(complex64 r, final int i, final int j, final int k) {
  baseArray[offset + this.region.ordinal(i,j,2*k)] = r.real;
  baseArray[offset + this.region.ordinal(i,j,2*k+1)] = r.imag;
 }

 public final void setc64(complex64 r, final int i, final int j, final int k, final int l) {
  baseArray[offset + this.region.ordinal(i,j,k,2*l)] = r.real;
  baseArray[offset + this.region.ordinal(i,j,k,2*l+1)] = r.imag;
 }

 public final void setc64(complex64 r, final int i, final int j, final int k, final int l, final int m) {
  baseArray[offset + this.region.ordinal(i,j,k,l,2*m)] = r.real;
  baseArray[offset + this.region.ordinal(i,j,k,l,2*m+1)] = r.imag;
 }

}
