package hj.array.view;

import hj.array.SRegionRectangular;
import hj.lang.SArrayView;
import edu.rice.cs.mint.runtime.*;

public class SComplexArrayView extends SArrayView {
    
    public SComplexArrayView(int offset, SRegionRectangular r) {
        super(offset * 2, adaptBoundariesForComplex(r));
    }
    
    /**
     * Adapt region boundary so that we can use the doubled size
     * runtime representation of the complex64 array.
     * Ideally this should be handled by the compiler and we shouldn't
     * have to deal with this at runtime.
     * @param r
     * @return
     */
    public static SRegionRectangular adaptBoundariesForComplex(SRegionRectangular r){
        final int [] dimensions = new int [r.rank * 2];
        SRegionRectangular rr = (SRegionRectangular) r;
        
        if (r.rank == 1) { 
            dimensions[0] = rr.low_I;
            dimensions[1] = ((rr.low_I + rr.lg_I)*2)-1;
        }
        
        if (r.rank == 2) {
            dimensions[0] = rr.low_I;
            dimensions[1] = (rr.low_I + rr.lg_I)-1;
            dimensions[2] = rr.low_J;
            dimensions[3] = (rr.low_J + rr.lg_J*2)-1;
        }
        
        if (r.rank == 3) {
            dimensions[0] = rr.low_I;
            dimensions[1] = (rr.low_I + rr.lg_I)-1;
            dimensions[2] = rr.low_J;
            dimensions[3] = (rr.low_J + rr.lg_J)-1;
            dimensions[4] = rr.low_K;
            dimensions[5] = (rr.low_K + rr.lg_K*2)-1;
        }
        
        SRegionRectangular newRegion =  new SRegionRectangular(dimensions, rr.base);
        
        return newRegion;
    }
    
    public separable SafeCode<Integer> getRowOffset(final int i) {
        //compute new offset
        return <| `(region.ordinal(<|i|>, region.clow_J)) / 2 |>;
    }
    
    public separable SafeCode<Integer> getRowOffset(final int i, final int j) {
        //compute new offset
        return <| `(region.ordinal(<|i|>, <|j|>, region.clow_K)) / 2 |>;
    }
    
    
}
